package org.openqa.selenium.devtools.v144.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum SRIMessageSignatureError {

    MISSINGSIGNATUREHEADER("MissingSignatureHeader"),
    MISSINGSIGNATUREINPUTHEADER("MissingSignatureInputHeader"),
    INVALIDSIGNATUREHEADER("InvalidSignatureHeader"),
    INVALIDSIGNATUREINPUTHEADER("InvalidSignatureInputHeader"),
    SIGNATUREHEADERVALUEISNOTBYTESEQUENCE("SignatureHeaderValueIsNotByteSequence"),
    SIGNATUREHEADERVALUEISPARAMETERIZED("SignatureHeaderValueIsParameterized"),
    SIGNATUREHEADERVALUEISINCORRECTLENGTH("SignatureHeaderValueIsIncorrectLength"),
    SIGNATUREINPUTHEADERMISSINGLABEL("SignatureInputHeaderMissingLabel"),
    SIGNATUREINPUTHEADERVALUENOTINNERLIST("SignatureInputHeaderValueNotInnerList"),
    SIGNATUREINPUTHEADERVALUEMISSINGCOMPONENTS("SignatureInputHeaderValueMissingComponents"),
    SIGNATUREINPUTHEADERINVALIDCOMPONENTTYPE("SignatureInputHeaderInvalidComponentType"),
    SIGNATUREINPUTHEADERINVALIDCOMPONENTNAME("SignatureInputHeaderInvalidComponentName"),
    SIGNATUREINPUTHEADERINVALIDHEADERCOMPONENTPARAMETER("SignatureInputHeaderInvalidHeaderComponentParameter"),
    SIGNATUREINPUTHEADERINVALIDDERIVEDCOMPONENTPARAMETER("SignatureInputHeaderInvalidDerivedComponentParameter"),
    SIGNATUREINPUTHEADERKEYIDLENGTH("SignatureInputHeaderKeyIdLength"),
    SIGNATUREINPUTHEADERINVALIDPARAMETER("SignatureInputHeaderInvalidParameter"),
    SIGNATUREINPUTHEADERMISSINGREQUIREDPARAMETERS("SignatureInputHeaderMissingRequiredParameters"),
    VALIDATIONFAILEDSIGNATUREEXPIRED("ValidationFailedSignatureExpired"),
    VALIDATIONFAILEDINVALIDLENGTH("ValidationFailedInvalidLength"),
    VALIDATIONFAILEDSIGNATUREMISMATCH("ValidationFailedSignatureMismatch"),
    VALIDATIONFAILEDINTEGRITYMISMATCH("ValidationFailedIntegrityMismatch");

    private String value;

    SRIMessageSignatureError(String value) {
        this.value = value;
    }

    public static SRIMessageSignatureError fromString(String s) {
        return java.util.Arrays.stream(SRIMessageSignatureError.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SRIMessageSignatureError "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SRIMessageSignatureError fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
