package org.openqa.selenium.devtools.v143.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class AttributionReportingReportSent {

    private final java.lang.String url;

    private final java.util.Map<String, Object> body;

    private final org.openqa.selenium.devtools.v143.storage.model.AttributionReportingReportResult result;

    private final java.util.Optional<java.lang.Integer> netError;

    private final java.util.Optional<java.lang.String> netErrorName;

    private final java.util.Optional<java.lang.Integer> httpStatusCode;

    public AttributionReportingReportSent(java.lang.String url, java.util.Map<String, Object> body, org.openqa.selenium.devtools.v143.storage.model.AttributionReportingReportResult result, java.util.Optional<java.lang.Integer> netError, java.util.Optional<java.lang.String> netErrorName, java.util.Optional<java.lang.Integer> httpStatusCode) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.body = java.util.Objects.requireNonNull(body, "body is required");
        this.result = java.util.Objects.requireNonNull(result, "result is required");
        this.netError = netError;
        this.netErrorName = netErrorName;
        this.httpStatusCode = httpStatusCode;
    }

    public java.lang.String getUrl() {
        return url;
    }

    public java.util.Map<String, Object> getBody() {
        return body;
    }

    public org.openqa.selenium.devtools.v143.storage.model.AttributionReportingReportResult getResult() {
        return result;
    }

    /**
     * If result is `sent`, populated with net/HTTP status.
     */
    public java.util.Optional<java.lang.Integer> getNetError() {
        return netError;
    }

    public java.util.Optional<java.lang.String> getNetErrorName() {
        return netErrorName;
    }

    public java.util.Optional<java.lang.Integer> getHttpStatusCode() {
        return httpStatusCode;
    }

    private static AttributionReportingReportSent fromJson(JsonInput input) {
        java.lang.String url = null;
        java.util.Map<String, Object> body = null;
        org.openqa.selenium.devtools.v143.storage.model.AttributionReportingReportResult result = null;
        java.util.Optional<java.lang.Integer> netError = java.util.Optional.empty();
        java.util.Optional<java.lang.String> netErrorName = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> httpStatusCode = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "body":
                    body = (java.util.Map<String, Object>) input.read(java.util.Map.class);
                    break;
                case "result":
                    result = input.read(org.openqa.selenium.devtools.v143.storage.model.AttributionReportingReportResult.class);
                    break;
                case "netError":
                    netError = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "netErrorName":
                    netErrorName = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "httpStatusCode":
                    httpStatusCode = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AttributionReportingReportSent(url, body, result, netError, netErrorName, httpStatusCode);
    }
}
