package org.openqa.selenium.devtools.v143.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum RuleSetErrorType {

    SOURCEISNOTJSONOBJECT("SourceIsNotJsonObject"), INVALIDRULESSKIPPED("InvalidRulesSkipped"), INVALIDRULESETLEVELTAG("InvalidRulesetLevelTag");

    private String value;

    RuleSetErrorType(String value) {
        this.value = value;
    }

    public static RuleSetErrorType fromString(String s) {
        return java.util.Arrays.stream(RuleSetErrorType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within RuleSetErrorType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static RuleSetErrorType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
