package org.openqa.selenium.devtools.v143.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a prerender attempt is updated.
 */
public class PrerenderStatusUpdated {

    private final org.openqa.selenium.devtools.v143.preload.model.PreloadingAttemptKey key;

    private final org.openqa.selenium.devtools.v143.preload.model.PreloadPipelineId pipelineId;

    private final org.openqa.selenium.devtools.v143.preload.model.PreloadingStatus status;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.preload.model.PrerenderFinalStatus> prerenderStatus;

    private final java.util.Optional<java.lang.String> disallowedMojoInterface;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.preload.model.PrerenderMismatchedHeaders>> mismatchedHeaders;

    public PrerenderStatusUpdated(org.openqa.selenium.devtools.v143.preload.model.PreloadingAttemptKey key, org.openqa.selenium.devtools.v143.preload.model.PreloadPipelineId pipelineId, org.openqa.selenium.devtools.v143.preload.model.PreloadingStatus status, java.util.Optional<org.openqa.selenium.devtools.v143.preload.model.PrerenderFinalStatus> prerenderStatus, java.util.Optional<java.lang.String> disallowedMojoInterface, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.preload.model.PrerenderMismatchedHeaders>> mismatchedHeaders) {
        this.key = java.util.Objects.requireNonNull(key, "key is required");
        this.pipelineId = java.util.Objects.requireNonNull(pipelineId, "pipelineId is required");
        this.status = java.util.Objects.requireNonNull(status, "status is required");
        this.prerenderStatus = prerenderStatus;
        this.disallowedMojoInterface = disallowedMojoInterface;
        this.mismatchedHeaders = mismatchedHeaders;
    }

    public org.openqa.selenium.devtools.v143.preload.model.PreloadingAttemptKey getKey() {
        return key;
    }

    public org.openqa.selenium.devtools.v143.preload.model.PreloadPipelineId getPipelineId() {
        return pipelineId;
    }

    public org.openqa.selenium.devtools.v143.preload.model.PreloadingStatus getStatus() {
        return status;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v143.preload.model.PrerenderFinalStatus> getPrerenderStatus() {
        return prerenderStatus;
    }

    /**
     * This is used to give users more information about the name of Mojo interface
     * that is incompatible with prerender and has caused the cancellation of the attempt.
     */
    public java.util.Optional<java.lang.String> getDisallowedMojoInterface() {
        return disallowedMojoInterface;
    }

    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.preload.model.PrerenderMismatchedHeaders>> getMismatchedHeaders() {
        return mismatchedHeaders;
    }

    private static PrerenderStatusUpdated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v143.preload.model.PreloadingAttemptKey key = null;
        org.openqa.selenium.devtools.v143.preload.model.PreloadPipelineId pipelineId = null;
        org.openqa.selenium.devtools.v143.preload.model.PreloadingStatus status = null;
        java.util.Optional<org.openqa.selenium.devtools.v143.preload.model.PrerenderFinalStatus> prerenderStatus = java.util.Optional.empty();
        java.util.Optional<java.lang.String> disallowedMojoInterface = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.preload.model.PrerenderMismatchedHeaders>> mismatchedHeaders = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "key":
                    key = input.read(org.openqa.selenium.devtools.v143.preload.model.PreloadingAttemptKey.class);
                    break;
                case "pipelineId":
                    pipelineId = input.read(org.openqa.selenium.devtools.v143.preload.model.PreloadPipelineId.class);
                    break;
                case "status":
                    status = input.read(org.openqa.selenium.devtools.v143.preload.model.PreloadingStatus.class);
                    break;
                case "prerenderStatus":
                    prerenderStatus = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.preload.model.PrerenderFinalStatus.class));
                    break;
                case "disallowedMojoInterface":
                    disallowedMojoInterface = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "mismatchedHeaders":
                    mismatchedHeaders = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.preload.model.PrerenderMismatchedHeaders.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PrerenderStatusUpdated(key, pipelineId, status, prerenderStatus, disallowedMojoInterface, mismatchedHeaders);
    }
}
