package org.openqa.selenium.devtools.v143.dom.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Physical scroll orientation
 */
public enum ScrollOrientation {

    HORIZONTAL("horizontal"), VERTICAL("vertical");

    private String value;

    ScrollOrientation(String value) {
        this.value = value;
    }

    public static ScrollOrientation fromString(String s) {
        return java.util.Arrays.stream(ScrollOrientation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ScrollOrientation "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ScrollOrientation fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
