/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public class Read {
    private Read() {
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        int estimatedSize = Math.max(in.available(), 1024);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(estimatedSize);){
            int readCount;
            byte[] buffer = new byte[Math.min(estimatedSize, 4096)];
            while ((readCount = in.read(buffer)) != -1) {
                out.write(buffer, 0, readCount);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static String toString(InputStream in) throws IOException {
        return new String(Read.toByteArray(in), StandardCharsets.UTF_8);
    }

    public static String resourceAsString(String resource) {
        String string;
        block9: {
            InputStream stream = Read.class.getResourceAsStream(resource);
            try {
                if (stream == null) {
                    throw new IllegalArgumentException("Resource not found: " + resource);
                }
                string = Read.toString(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to read resource " + resource, e);
                }
            }
            stream.close();
        }
        return string;
    }
}

