/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Base64;
import java.util.Map;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasExtensions
implements AugmenterProvider<HasExtensions>,
AdditionalHttpCommands {
    public static final String INSTALL_EXTENSION = "installExtension";
    public static final String UNINSTALL_EXTENSION = "uninstallExtension";
    private static final Map<String, CommandInfo> COMMANDS = Map.of("installExtension", new CommandInfo("/session/:sessionId/moz/addon/install", HttpMethod.POST), "uninstallExtension", new CommandInfo("/session/:sessionId/moz/addon/uninstall", HttpMethod.POST));

    @Override
    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    @Override
    public Predicate<Capabilities> isApplicable() {
        return Browser.FIREFOX::is;
    }

    @Override
    public Class<HasExtensions> getDescribedInterface() {
        return HasExtensions.class;
    }

    @Override
    public HasExtensions getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasExtensions(){

            @Override
            public String installExtension(Path path) {
                return this.installExtension(path, false);
            }

            @Override
            public String installExtension(Path path, Boolean temporary) {
                String encoded;
                Require.nonNull("Extension Path", path);
                Require.nonNull("Temporary", temporary);
                try {
                    encoded = Files.isDirectory(path, new LinkOption[0]) ? Base64.getEncoder().encodeToString(this.zipDirectory(path)) : Base64.getEncoder().encodeToString(Files.readAllBytes(path));
                }
                catch (IOException e) {
                    throw new InvalidArgumentException(String.valueOf(path) + " is an invalid path", e);
                }
                return (String)executeMethod.execute(AddHasExtensions.INSTALL_EXTENSION, Map.of("addon", encoded, "temporary", temporary));
            }

            private byte[] zipDirectory(final Path path) throws IOException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (final ZipOutputStream zos = new ZipOutputStream(baos);){
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            String entryName = path.relativize(file).toString().replace(File.separatorChar, '/');
                            zos.putNextEntry(new ZipEntry(entryName));
                            Files.copy(file, zos);
                            zos.closeEntry();
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                return baos.toByteArray();
            }

            @Override
            public void uninstallExtension(String extensionId) {
                Require.nonNull("Extension ID", extensionId);
                executeMethod.execute(AddHasExtensions.UNINSTALL_EXTENSION, Map.of("id", extensionId));
            }
        };
    }
}

