/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.docker.client.ApiVersionAdapter;

class V148Adapter
implements ApiVersionAdapter {
    private static final Logger LOG = Logger.getLogger(V148Adapter.class.getName());
    private final String apiVersion;

    public V148Adapter(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public Map<String, Object> adaptImageResponse(Map<String, Object> response) {
        String mediaType;
        Object platformObj;
        Map descriptor;
        if (response == null) {
            return response;
        }
        HashMap<String, Object> adapted = new HashMap<String, Object>(response);
        if (adapted.containsKey("VirtualSize")) {
            LOG.warning("VirtualSize field found in API v" + this.apiVersion + " response. This field was removed in v1.44.");
            adapted.remove("VirtualSize");
        }
        if (!adapted.containsKey("Size")) {
            LOG.warning("Size field missing from image response in API v" + this.apiVersion);
        }
        if (adapted.containsKey("ImageManifestDescriptor") && (descriptor = (Map)adapted.get("ImageManifestDescriptor")) != null && descriptor.containsKey("platform") && (platformObj = descriptor.get("platform")) instanceof Map) {
            Map platform = (Map)platformObj;
            String arch = (String)platform.get("architecture");
            String os = (String)platform.get("os");
            if (arch != null && os != null) {
                LOG.fine(String.format("Image is platform-specific: %s/%s (API v%s multi-platform support)", os, arch, this.apiVersion));
            }
        }
        if (adapted.containsKey("Descriptor") && (descriptor = (Map)adapted.get("Descriptor")) != null && (mediaType = (String)descriptor.get("mediaType")) != null) {
            LOG.fine("Image includes OCI descriptor with mediaType: " + mediaType);
        }
        return adapted;
    }

    @Override
    public Map<String, Object> adaptContainerCreateRequest(Map<String, Object> request) {
        Map endpointsConfig;
        Map networkingConfig;
        Object mounts;
        if (request == null) {
            return request;
        }
        HashMap<String, Object> adapted = new HashMap<String, Object>(request);
        Map hostConfig = (Map)adapted.get("HostConfig");
        if (hostConfig != null && (mounts = hostConfig.get("Mounts")) instanceof Iterable) {
            for (Object mount : (Iterable)mounts) {
                Map mountMap;
                String type;
                if (!(mount instanceof Map) || !"image".equals(type = (String)(mountMap = (Map)mount).get("Type"))) continue;
                String source = (String)mountMap.get("Source");
                String target = (String)mountMap.get("Target");
                if (source == null || source.isEmpty()) {
                    LOG.warning("Image mount missing required 'Source' field");
                }
                if (target == null || target.isEmpty()) {
                    LOG.warning("Image mount missing required 'Target' field");
                }
                if (source == null || target == null) continue;
                LOG.fine(String.format("Mounting image '%s' at '%s' (API v%s+ image mount support)", source, target, this.apiVersion));
            }
        }
        if ((networkingConfig = (Map)adapted.get("NetworkingConfig")) != null && (endpointsConfig = (Map)networkingConfig.get("EndpointsConfig")) != null && endpointsConfig.size() > 1) {
            int highestPriority = Integer.MIN_VALUE;
            String defaultGatewayNetwork = null;
            for (Map.Entry entry : endpointsConfig.entrySet()) {
                Object priorityObj;
                int priority;
                Map endpointConfig;
                if (!(entry.getValue() instanceof Map) || !(endpointConfig = (Map)entry.getValue()).containsKey("GwPriority") || (priority = (priorityObj = endpointConfig.get("GwPriority")) instanceof Number ? ((Number)priorityObj).intValue() : 0) <= highestPriority) continue;
                highestPriority = priority;
                defaultGatewayNetwork = (String)entry.getKey();
            }
            if (defaultGatewayNetwork != null) {
                LOG.fine(String.format("Container will use '%s' as default gateway (priority: %d, API v%s+)", defaultGatewayNetwork, highestPriority, this.apiVersion));
            } else {
                LOG.fine(String.format("Creating container with %d networks, no explicit gateway priority set", endpointsConfig.size()));
            }
        }
        return adapted;
    }

    @Override
    public Map<String, Object> adaptContainerInspectResponse(Map<String, Object> response) {
        Map originalNetworkSettings;
        Object platformObj;
        Map descriptor;
        if (response == null) {
            return response;
        }
        HashMap<String, Object> adapted = new HashMap<String, Object>(response);
        if (adapted.containsKey("ImageManifestDescriptor") && (descriptor = (Map)adapted.get("ImageManifestDescriptor")) != null && descriptor.containsKey("platform") && (platformObj = descriptor.get("platform")) instanceof Map) {
            Map platform = (Map)platformObj;
            String arch = (String)platform.get("architecture");
            String os = (String)platform.get("os");
            String digest = (String)descriptor.get("digest");
            if (arch != null && os != null) {
                LOG.fine(String.format("Container running on %s/%s platform (digest: %s, API v%s+)", os, arch, digest != null ? digest.substring(0, Math.min(12, digest.length())) : "unknown", this.apiVersion));
            }
        }
        if ((originalNetworkSettings = (Map)adapted.get("NetworkSettings")) != null) {
            String[] deprecatedFields;
            HashMap networkSettings = new HashMap(originalNetworkSettings);
            adapted.put("NetworkSettings", networkSettings);
            Map networks = (Map)networkSettings.get("Networks");
            if (networks != null && networks.size() > 1) {
                int highestPriority = Integer.MIN_VALUE;
                String defaultGatewayNetwork = null;
                for (Map.Entry entry : networks.entrySet()) {
                    Object priorityObj;
                    int priority;
                    Map network;
                    if (!(entry.getValue() instanceof Map) || !(network = (Map)entry.getValue()).containsKey("GwPriority") || (priority = (priorityObj = network.get("GwPriority")) instanceof Number ? ((Number)priorityObj).intValue() : 0) <= highestPriority) continue;
                    highestPriority = priority;
                    defaultGatewayNetwork = (String)entry.getKey();
                }
                if (defaultGatewayNetwork != null) {
                    LOG.fine(String.format("Container using '%s' as default gateway (priority: %d)", defaultGatewayNetwork, highestPriority));
                }
            }
            for (String field : deprecatedFields = new String[]{"HairpinMode", "LinkLocalIPv6Address", "LinkLocalIPv6PrefixLen", "SecondaryIPAddresses", "SecondaryIPv6Addresses", "Bridge"}) {
                if (!networkSettings.containsKey(field)) continue;
                LOG.fine("Removing deprecated field '" + field + "' from NetworkSettings (deprecated in earlier API versions)");
                networkSettings.remove(field);
            }
        }
        return adapted;
    }

    @Override
    public boolean supportsMultipleNetworks() {
        return true;
    }

    @Override
    public boolean hasVirtualSizeField() {
        return false;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public boolean supportsMultiPlatform() {
        return true;
    }

    public boolean supportsImageMountType() {
        return true;
    }

    public boolean supportsGatewayPriority() {
        return true;
    }

    public boolean supportsIPv4Control() {
        return true;
    }
}

