/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.emulation;

import java.lang.reflect.Type;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.emulation.SetGeolocationOverrideParameters;
import org.openqa.selenium.bidi.emulation.SetNetworkConditionsParameters;
import org.openqa.selenium.bidi.emulation.SetScreenOrientationOverrideParameters;
import org.openqa.selenium.bidi.emulation.SetScriptingEnabledParameters;
import org.openqa.selenium.bidi.emulation.SetTimezoneOverrideParameters;
import org.openqa.selenium.bidi.emulation.SetUserAgentOverrideParameters;
import org.openqa.selenium.internal.Require;

public class Emulation {
    private final BiDi bidi;

    public Emulation(WebDriver driver) {
        Require.nonNull("WebDriver", driver);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver must implement BiDi interface");
        }
        this.bidi = ((HasBiDi)((Object)driver)).getBiDi();
    }

    public void setGeolocationOverride(SetGeolocationOverrideParameters parameters) {
        Require.nonNull("SetGeolocationOverride parameters", parameters);
        this.bidi.send(new Command("emulation.setGeolocationOverride", parameters.toMap(), (Type)((Object)Map.class)));
    }

    public void setTimezoneOverride(SetTimezoneOverrideParameters parameters) {
        Require.nonNull("SetTimezoneOverride parameters", parameters);
        this.bidi.send(new Command("emulation.setTimezoneOverride", parameters.toMap(), (Type)((Object)Map.class)));
    }

    public void setScriptingEnabled(SetScriptingEnabledParameters parameters) {
        Require.nonNull("SetScriptingEnabled parameters", parameters);
        this.bidi.send(new Command("emulation.setScriptingEnabled", parameters.toMap(), (Type)((Object)Map.class)));
    }

    public void setUserAgentOverride(SetUserAgentOverrideParameters parameters) {
        Require.nonNull("SetUserAgentOverride parameters", parameters);
        this.bidi.send(new Command("emulation.setUserAgentOverride", parameters.toMap(), (Type)((Object)Map.class)));
    }

    public void setScreenOrientationOverride(SetScreenOrientationOverrideParameters parameters) {
        Require.nonNull("SetScreenOrientationOverride parameters", parameters);
        this.bidi.send(new Command("emulation.setScreenOrientationOverride", parameters.toMap(), (Type)((Object)Map.class)));
    }

    public void setNetworkConditions(SetNetworkConditionsParameters parameters) {
        Require.nonNull("SetNetworkConditions parameters", parameters);
        this.bidi.send(new Command("emulation.setNetworkConditions", parameters.toMap(), (Type)((Object)Map.class)));
    }
}

