/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.execution.instrumentation.DocumentAndVariables;
import graphql.language.Document;
import graphql.parser.InvalidSyntaxException;
import graphql.validation.ValidationError;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class ParseAndValidateResult {
    private final Document document;
    private final Map<String, Object> variables;
    private final InvalidSyntaxException syntaxException;
    private final List<ValidationError> validationErrors;

    private ParseAndValidateResult(Builder builder) {
        this.document = builder.document;
        this.variables = builder.variables == null ? ImmutableKit.emptyMap() : builder.variables;
        this.syntaxException = builder.syntaxException;
        this.validationErrors = builder.validationErrors == null ? ImmutableKit.emptyList() : builder.validationErrors;
    }

    public boolean isFailure() {
        return this.syntaxException != null || !this.validationErrors.isEmpty();
    }

    public Document getDocument() {
        return this.document;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public DocumentAndVariables getDocumentAndVariables() {
        if (this.document != null) {
            return DocumentAndVariables.newDocumentAndVariables().document(this.document).variables(this.variables).build();
        }
        return null;
    }

    public InvalidSyntaxException getSyntaxException() {
        return this.syntaxException;
    }

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public List<GraphQLError> getErrors() {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        if (this.syntaxException != null) {
            errors.add(this.syntaxException.toInvalidSyntaxError());
        }
        errors.addAll(this.validationErrors);
        return errors;
    }

    public ParseAndValidateResult transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder().document(this.document).variables(this.variables).syntaxException(this.syntaxException).validationErrors(this.validationErrors);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newResult() {
        return new Builder();
    }

    public static class Builder {
        private Document document;
        private Map<String, Object> variables = ImmutableKit.emptyMap();
        private InvalidSyntaxException syntaxException;
        private List<ValidationError> validationErrors = ImmutableKit.emptyList();

        public Builder document(Document document) {
            this.document = document;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public Builder validationErrors(List<ValidationError> validationErrors) {
            this.validationErrors = validationErrors;
            return this;
        }

        public Builder syntaxException(InvalidSyntaxException syntaxException) {
            this.syntaxException = syntaxException;
            return this;
        }

        public ParseAndValidateResult build() {
            return new ParseAndValidateResult(this);
        }
    }
}

