/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.function.IOIterable;
import org.apache.commons.io.function.IOIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class IOIterableTest {
    private IOIterable<Path> iterable;
    private Fixture fixture;

    IOIterableTest() {
    }

    @BeforeEach
    public void beforeEach() {
        this.iterable = this.fixture = new Fixture();
    }

    @Test
    void testForEach() throws IOException {
        AtomicInteger ref = new AtomicInteger();
        Assertions.assertThrows(NullPointerException.class, () -> this.iterable.forEach(null));
        this.iterable.forEach(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
    }

    @Test
    void testIterator() throws IOException {
        AtomicInteger ref = new AtomicInteger();
        this.iterable.iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
    }

    @Test
    void testSpliterator() throws IOException {
        AtomicInteger ref = new AtomicInteger();
        this.iterable.spliterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
    }

    @Test
    void testUnrwap() throws IOException {
        Assertions.assertSame(this.fixture.list, (Object)this.iterable.unwrap());
        Assertions.assertSame(this.fixture.unwrap(), (Object)this.iterable.unwrap());
    }

    private static class Fixture
    implements IOIterable<Path> {
        List<Path> list = Arrays.asList(Paths.get("a", new String[0]), Paths.get("b", new String[0]));

        private Fixture() {
        }

        public IOIterator<Path> iterator() {
            return IOIterator.adapt(this.list);
        }

        public Iterable<Path> unwrap() {
            return this.list;
        }
    }
}

