/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.pagefactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@NullMarked
public class ByChained
extends By
implements Serializable {
    private static final long serialVersionUID = 1563769051170172451L;
    private final By[] bys;

    public ByChained(By ... bys) {
        this.bys = bys;
    }

    @Override
    public WebElement findElement(SearchContext context) {
        List<WebElement> elements = this.findElements(context);
        if (elements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element using " + String.valueOf(this));
        }
        return elements.get(0);
    }

    @Override
    public List<WebElement> findElements(SearchContext context) {
        if (this.bys.length == 0) {
            return new ArrayList<WebElement>();
        }
        List<WebElement> elems = this.bys[0].findElements(context);
        for (int i = 1; i < this.bys.length && !elems.isEmpty(); ++i) {
            By by = this.bys[i];
            elems = elems.stream().map(elem -> elem.findElements(by)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return elems;
    }

    @Override
    public String toString() {
        return String.format("By.chained({%s})", Stream.of(this.bys).map(By::toString).collect(Collectors.joining(",")));
    }
}

