/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.reactive;

import graphql.DuckTyped;
import graphql.Internal;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class ReactiveSupport {
    @DuckTyped(shape="CompletableFuture | Object")
    public static Object fetchedObject(Object fetchedObject) {
        if (fetchedObject instanceof Flow.Publisher) {
            return ReactiveSupport.flowPublisherToCF((Flow.Publisher)fetchedObject);
        }
        if (fetchedObject instanceof Publisher) {
            return ReactiveSupport.reactivePublisherToCF((Publisher)fetchedObject);
        }
        return fetchedObject;
    }

    private static CompletableFuture<Object> reactivePublisherToCF(Publisher<?> publisher) {
        ReactivePublisherToCompletableFuture<Object> cf = new ReactivePublisherToCompletableFuture<Object>();
        publisher.subscribe(cf);
        return cf;
    }

    private static CompletableFuture<Object> flowPublisherToCF(Flow.Publisher<?> publisher) {
        FlowPublisherToCompletableFuture<Object> cf = new FlowPublisherToCompletableFuture<Object>();
        publisher.subscribe(cf);
        return cf;
    }

    private static class FlowPublisherToCompletableFuture<T>
    extends PublisherToCompletableFuture<T, Flow.Subscription>
    implements Flow.Subscriber<T> {
        private FlowPublisherToCompletableFuture() {
        }

        @Override
        void doSubscriptionCancel(Flow.Subscription subscription) {
            subscription.cancel();
        }

        @Override
        void doSubscriptionRequest(Flow.Subscription subscription, long n) {
            subscription.request(n);
        }

        @Override
        public void onSubscribe(Flow.Subscription s2) {
            this.onSubscribeImpl(s2);
        }

        @Override
        public void onNext(T t2) {
            this.onNextImpl(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.onErrorImpl(t2);
        }

        @Override
        public void onComplete() {
            this.onCompleteImpl();
        }
    }

    private static class ReactivePublisherToCompletableFuture<T>
    extends PublisherToCompletableFuture<T, Subscription>
    implements Subscriber<T> {
        private ReactivePublisherToCompletableFuture() {
        }

        @Override
        void doSubscriptionCancel(Subscription subscription) {
            subscription.cancel();
        }

        @Override
        void doSubscriptionRequest(Subscription subscription, long n) {
            subscription.request(n);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.onSubscribeImpl(s2);
        }

        @Override
        public void onNext(T t2) {
            this.onNextImpl(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.onErrorImpl(t2);
        }

        @Override
        public void onComplete() {
            this.onCompleteImpl();
        }
    }

    private static abstract class PublisherToCompletableFuture<T, S>
    extends CompletableFuture<T> {
        private final AtomicReference<S> subscriptionRef = new AtomicReference();

        private PublisherToCompletableFuture() {
        }

        abstract void doSubscriptionCancel(S var1);

        abstract void doSubscriptionRequest(S var1, long var2);

        private boolean validateSubscription(S current, S next) {
            Objects.requireNonNull(next, "Subscription cannot be null");
            if (current != null) {
                this.doSubscriptionCancel(next);
                return false;
            }
            return true;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            S s2;
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && (s2 = this.subscriptionRef.getAndSet(null)) != null) {
                this.doSubscriptionCancel(s2);
            }
            return cancelled;
        }

        void onSubscribeImpl(S s2) {
            if (this.validateSubscription(this.subscriptionRef.getAndSet(s2), s2)) {
                this.doSubscriptionRequest(s2, Long.MAX_VALUE);
            }
        }

        void onNextImpl(T t2) {
            S s2 = this.subscriptionRef.getAndSet(null);
            if (s2 != null) {
                this.complete(t2);
                this.doSubscriptionCancel(s2);
            }
        }

        void onErrorImpl(Throwable t2) {
            if (this.subscriptionRef.getAndSet(null) != null) {
                this.completeExceptionally(t2);
            }
        }

        void onCompleteImpl() {
            if (this.subscriptionRef.getAndSet(null) != null) {
                this.complete(null);
            }
        }
    }
}

