/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.fieldvalidation;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.execution.AbortExecutionException;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.fieldvalidation.FieldValidation;
import graphql.execution.instrumentation.fieldvalidation.FieldValidationSupport;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import java.util.List;
import org.jspecify.annotations.Nullable;

@PublicApi
public class FieldValidationInstrumentation
extends SimplePerformantInstrumentation {
    private final FieldValidation fieldValidation;

    public FieldValidationInstrumentation(FieldValidation fieldValidation) {
        this.fieldValidation = Assert.assertNotNull(fieldValidation);
    }

    @Override
    public @Nullable InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState state) {
        List<GraphQLError> errors = FieldValidationSupport.validateFieldsAndArguments(this.fieldValidation, parameters.getExecutionContext());
        if (errors != null && !errors.isEmpty()) {
            throw new AbortExecutionException(errors);
        }
        return super.beginExecuteOperation(parameters, state);
    }
}

