/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.muxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jcodec.common.AudioCodecMeta;
import org.jcodec.common.AudioFormat;
import org.jcodec.common.Codec;
import org.jcodec.common.Muxer;
import org.jcodec.common.MuxerTrack;
import org.jcodec.common.Preconditions;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.containers.mp4.MP4TrackType;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.FileTypeBox;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.MovieHeaderBox;
import org.jcodec.containers.mp4.muxer.AbstractMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.CodecMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.PCMMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.TimecodeMP4MuxerTrack;

public class MP4Muxer
implements Muxer {
    private List<AbstractMP4MuxerTrack> tracks = new ArrayList<AbstractMP4MuxerTrack>();
    protected long mdatOffset;
    private int nextTrackId = 1;
    protected SeekableByteChannel out;

    public static MP4Muxer createMP4MuxerToChannel(SeekableByteChannel output) throws IOException {
        return new MP4Muxer(output, Brand.MP4.getFileTypeBox());
    }

    public static MP4Muxer createMP4Muxer(SeekableByteChannel output, Brand brand) throws IOException {
        return new MP4Muxer(output, brand.getFileTypeBox());
    }

    public MP4Muxer(SeekableByteChannel output, FileTypeBox ftyp) throws IOException {
        this.out = output;
        ByteBuffer buf = ByteBuffer.allocate(1024);
        ftyp.write(buf);
        Header.createHeader("wide", 8L).write(buf);
        Header.createHeader("mdat", 1L).write(buf);
        this.mdatOffset = buf.position();
        buf.putLong(0L);
        buf.flip();
        output.write(buf);
    }

    public TimecodeMP4MuxerTrack addTimecodeTrack() {
        return this.addTrack(new TimecodeMP4MuxerTrack(this.nextTrackId++));
    }

    public CodecMP4MuxerTrack addTrackWithId(MP4TrackType type, Codec codec, int trackId) {
        Preconditions.checkArgument(!this.hasTrackId(trackId), "track with id %s already exists", trackId);
        CodecMP4MuxerTrack track = new CodecMP4MuxerTrack(trackId, type, codec);
        this.tracks.add(track);
        this.nextTrackId = Math.max(this.nextTrackId, trackId + 1);
        return track;
    }

    public int getNextTrackId() {
        return this.nextTrackId;
    }

    private CodecMP4MuxerTrack doAddTrack(MP4TrackType type, Codec codec) {
        return this.addTrack(new CodecMP4MuxerTrack(this.nextTrackId++, type, codec));
    }

    public <T extends AbstractMP4MuxerTrack> T addTrack(T track) {
        Preconditions.checkNotNull(track, "track can not be null");
        int trackId = track.getTrackId();
        Preconditions.checkArgument(trackId <= this.nextTrackId);
        Preconditions.checkArgument(!this.hasTrackId(trackId), "track with id %s already exists", trackId);
        this.tracks.add(track.setOut(this.out));
        this.nextTrackId = Math.max(trackId + 1, this.nextTrackId);
        return track;
    }

    public boolean hasTrackId(int trackId) {
        for (AbstractMP4MuxerTrack t2 : this.tracks) {
            if (t2.getTrackId() != trackId) continue;
            return true;
        }
        return false;
    }

    public List<AbstractMP4MuxerTrack> getTracks() {
        return Collections.unmodifiableList(this.tracks);
    }

    @Override
    public void finish() throws IOException {
        Preconditions.checkState(this.tracks.size() != 0, "Can not save header with 0 tracks.");
        MovieBox movie = this.finalizeHeader();
        this.storeHeader(movie);
    }

    public void storeHeader(MovieBox movie) throws IOException {
        long mdatSize = this.out.position() - this.mdatOffset + 8L;
        MP4Util.writeMovie(this.out, movie);
        this.out.setPosition(this.mdatOffset);
        NIOUtils.writeLong(this.out, mdatSize);
    }

    public MovieBox finalizeHeader() throws IOException {
        MovieBox movie = MovieBox.createMovieBox();
        MovieHeaderBox mvhd = this.movieHeader();
        movie.addFirst(mvhd);
        for (AbstractMP4MuxerTrack track : this.tracks) {
            Box trak = track.finish(mvhd);
            if (trak == null) continue;
            movie.add(trak);
        }
        return movie;
    }

    public AbstractMP4MuxerTrack getVideoTrack() {
        for (AbstractMP4MuxerTrack frameMuxer : this.tracks) {
            if (!frameMuxer.isVideo()) continue;
            return frameMuxer;
        }
        return null;
    }

    public AbstractMP4MuxerTrack getTimecodeTrack() {
        for (AbstractMP4MuxerTrack frameMuxer : this.tracks) {
            if (!frameMuxer.isTimecode()) continue;
            return frameMuxer;
        }
        return null;
    }

    public List<AbstractMP4MuxerTrack> getAudioTracks() {
        ArrayList<AbstractMP4MuxerTrack> result = new ArrayList<AbstractMP4MuxerTrack>();
        for (AbstractMP4MuxerTrack frameMuxer : this.tracks) {
            if (!frameMuxer.isAudio()) continue;
            result.add(frameMuxer);
        }
        return result;
    }

    private MovieHeaderBox movieHeader() {
        int timescale = this.tracks.get(0).getTimescale();
        long duration = this.tracks.get(0).getTrackTotalDuration();
        AbstractMP4MuxerTrack videoTrack = this.getVideoTrack();
        if (videoTrack != null) {
            timescale = videoTrack.getTimescale();
            duration = videoTrack.getTrackTotalDuration();
        }
        return MovieHeaderBox.createMovieHeaderBox(timescale, duration, 1.0f, 1.0f, new Date().getTime(), new Date().getTime(), new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000}, this.nextTrackId);
    }

    public PCMMP4MuxerTrack addPCMAudioTrack(AudioFormat format) {
        return this.addTrack(new PCMMP4MuxerTrack(this.nextTrackId++, format));
    }

    public CodecMP4MuxerTrack addCompressedAudioTrack(Codec codec, AudioFormat format) {
        CodecMP4MuxerTrack track = this.doAddTrack(MP4TrackType.SOUND, codec);
        track.addAudioSampleEntry(format);
        return track;
    }

    @Override
    public MuxerTrack addVideoTrack(Codec codec, VideoCodecMeta meta) {
        CodecMP4MuxerTrack track = this.doAddTrack(MP4TrackType.VIDEO, codec);
        Preconditions.checkArgument(meta != null || codec == Codec.H264, "VideoCodecMeta is required upfront for all codecs but H.264");
        track.addVideoSampleEntry(meta);
        return track;
    }

    @Override
    public MuxerTrack addAudioTrack(Codec codec, AudioCodecMeta meta) {
        AudioFormat format = meta.getFormat();
        if (codec == Codec.PCM) {
            return this.addPCMAudioTrack(format);
        }
        return this.addCompressedAudioTrack(codec, format);
    }
}

