/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class DeferredFileOutputStreamTest
extends AbstractTempDirTest {
    private final String testString = "0123456789";
    private final byte[] testBytes = "0123456789".getBytes();

    public static IntStream data() {
        return IntStream.of(1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096);
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testAboveThreshold(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testAboveThreshold", "dat", new FileAttribute[0]).toFile();
        try (DeferredFileOutputStream dfos = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(this.testBytes.length - 5).setBufferSize(initialBufferSize)).setOutputFile(testFile).get();){
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
            Assertions.assertFalse((boolean)dfos.isInMemory());
            Assertions.assertNull((Object)dfos.getData());
            Assertions.assertEquals((long)testFile.length(), (long)dfos.getByteCount());
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testAboveThresholdGetInputStream(int initialBufferSize, @TempDir Path tempDir) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testAboveThreshold", "dat", new FileAttribute[0]).toFile();
        try (DeferredFileOutputStream dfos = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(this.testBytes.length - 5).setBufferSize(initialBufferSize)).setOutputFile(testFile).get();){
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
            Assertions.assertFalse((boolean)dfos.isInMemory());
            Assertions.assertEquals((long)testFile.length(), (long)dfos.getByteCount());
            try (InputStream is = dfos.toInputStream();){
                Assertions.assertArrayEquals((byte[])this.testBytes, (byte[])IOUtils.toByteArray(is));
            }
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testAtThreshold(int initialBufferSize) throws IOException {
        try (DeferredFileOutputStream dfos = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(this.testBytes.length).setBufferSize(initialBufferSize)).get();){
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
            Assertions.assertTrue((boolean)dfos.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            byte[] resultBytes = dfos.getData();
            Assertions.assertEquals((int)this.testBytes.length, (int)resultBytes.length);
            Assertions.assertArrayEquals((byte[])resultBytes, (byte[])this.testBytes);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testBelowThreshold(int initialBufferSize) throws IOException {
        try (DeferredFileOutputStream dfos = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(this.testBytes.length + 42).setBufferSize(initialBufferSize)).get();){
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
            Assertions.assertTrue((boolean)dfos.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            byte[] resultBytes = dfos.getData();
            Assertions.assertEquals((int)this.testBytes.length, (int)resultBytes.length);
            Assertions.assertArrayEquals((byte[])resultBytes, (byte[])this.testBytes);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testBelowThresholdGetInputStream(int initialBufferSize) throws IOException {
        try (DeferredFileOutputStream dfos = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(this.testBytes.length + 42).setBufferSize(initialBufferSize)).get();){
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
            Assertions.assertTrue((boolean)dfos.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            try (InputStream is = dfos.toInputStream();){
                Assertions.assertArrayEquals((byte[])this.testBytes, (byte[])IOUtils.toByteArray(is));
            }
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testTempFileAboveThreshold(int initialBufferSize) throws IOException {
        String prefix = "commons-io-test";
        String suffix = ".out";
        try (DeferredFileOutputStream dfos = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(this.testBytes.length - 5).setBufferSize(initialBufferSize)).setPrefix("commons-io-test").setSuffix(".out").setDirectory(this.tempDirFile).setDirectory(this.tempDirPath.toFile()).get();){
            Assertions.assertNull((Object)dfos.getFile(), (String)"Check File is null-A");
            Assertions.assertNull((Object)dfos.getPath(), (String)"Check Path is null-A");
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
            Assertions.assertFalse((boolean)dfos.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            Assertions.assertNull((Object)dfos.getData());
            Assertions.assertNotNull((Object)dfos.getFile(), (String)"Check file not null");
            Assertions.assertTrue((boolean)dfos.getFile().exists(), (String)"Check file exists");
            Assertions.assertTrue((boolean)dfos.getFile().getName().startsWith("commons-io-test"), (String)"Check prefix");
            Assertions.assertTrue((boolean)dfos.getFile().getName().endsWith(".out"), (String)"Check suffix");
            Assertions.assertEquals((Object)this.tempDirPath, (Object)dfos.getPath().getParent(), (String)"Check dir");
            this.verifyResultFile(dfos.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testTempFileAboveThresholdPrefixOnly(int initialBufferSize) throws IOException {
        String prefix = "commons-io-test";
        String suffix = null;
        try (DeferredFileOutputStream dfos = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(this.testBytes.length - 5).setBufferSize(initialBufferSize)).setPrefix("commons-io-test").setSuffix(suffix).setDirectory((Path)null).get();){
            try {
                Assertions.assertNull((Object)dfos.getFile(), (String)"Check File is null-A");
                Assertions.assertNull((Object)dfos.getPath(), (String)"Check Path is null-A");
                dfos.write(this.testBytes, 0, this.testBytes.length);
                dfos.close();
                Assertions.assertFalse((boolean)dfos.isInMemory());
                Assertions.assertNull((Object)dfos.getData());
                Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
                Assertions.assertNotNull((Object)dfos.getFile(), (String)"Check file not null");
                Assertions.assertTrue((boolean)dfos.getFile().exists(), (String)"Check file exists");
                Assertions.assertTrue((boolean)dfos.getFile().getName().startsWith("commons-io-test"), (String)"Check prefix");
                Assertions.assertTrue((boolean)dfos.getFile().getName().endsWith(".tmp"), (String)"Check suffix");
                this.verifyResultFile(dfos.getFile());
            }
            finally {
                dfos.getFile().delete();
            }
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testTempFileBelowThreshold(int initialBufferSize) throws IOException {
        String prefix = "commons-io-test";
        String suffix = ".out";
        try (DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length + 42, initialBufferSize, "commons-io-test", ".out", this.tempDirFile);){
            Assertions.assertNull((Object)dfos.getFile(), (String)"Check File is null-A");
            Assertions.assertNull((Object)dfos.getPath(), (String)"Check Path is null-A");
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
            Assertions.assertTrue((boolean)dfos.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            Assertions.assertNull((Object)dfos.getFile(), (String)"Check file is null-B");
        }
    }

    @Test
    public void testTempFileError() throws Exception {
        String prefix = null;
        String suffix = ".out";
        Assertions.assertThrows(NullPointerException.class, () -> new DeferredFileOutputStream(this.testBytes.length - 5, prefix, ".out", this.tempDirFile));
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testThresholdNegative(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testThresholdNegative", "dat", new FileAttribute[0]).toFile();
        try (DeferredFileOutputStream dfos = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(-1).setBufferSize(initialBufferSize)).setOutputFile(testFile).get();){
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
            Assertions.assertFalse((boolean)dfos.isInMemory());
            Assertions.assertNull((Object)dfos.getData());
            Assertions.assertEquals((long)testFile.length(), (long)dfos.getByteCount());
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testThresholdReached(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testThresholdReached", "dat", new FileAttribute[0]).toFile();
        try (DeferredFileOutputStream dfos = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(this.testBytes.length / 2).setBufferSize(initialBufferSize)).setOutputFile(testFile).get();){
            int chunkSize = this.testBytes.length / 3;
            dfos.write(this.testBytes, 0, chunkSize);
            dfos.write(this.testBytes, chunkSize, chunkSize);
            dfos.write(this.testBytes, chunkSize * 2, this.testBytes.length - chunkSize * 2);
            dfos.close();
            Assertions.assertFalse((boolean)dfos.isInMemory());
            Assertions.assertNull((Object)dfos.getData());
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testWriteToLarge(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testWriteToFile", "dat", new FileAttribute[0]).toFile();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(initialBufferSize);
             DeferredFileOutputStream dfos = DeferredFileOutputStream.builder().setThreshold(this.testBytes.length / 2).setOutputFile(testFile).get();){
            dfos.write(this.testBytes);
            Assertions.assertTrue((boolean)testFile.exists());
            Assertions.assertFalse((boolean)dfos.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            Assertions.assertThrows(IOException.class, () -> dfos.writeTo(baos));
            dfos.close();
            dfos.writeTo(baos);
            byte[] copiedBytes = baos.toByteArray();
            Assertions.assertArrayEquals((byte[])this.testBytes, (byte[])copiedBytes);
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testWriteToLargeCtor(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testWriteToFile", "dat", new FileAttribute[0]).toFile();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(initialBufferSize);
             DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length / 2, testFile);){
            dfos.write(this.testBytes);
            Assertions.assertTrue((boolean)testFile.exists());
            Assertions.assertFalse((boolean)dfos.isInMemory());
            Assertions.assertThrows(IOException.class, () -> dfos.writeTo(baos));
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            dfos.close();
            dfos.writeTo(baos);
            byte[] copiedBytes = baos.toByteArray();
            Assertions.assertArrayEquals((byte[])this.testBytes, (byte[])copiedBytes);
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testWriteToSmall(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testWriteToMem", "dat", new FileAttribute[0]).toFile();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(initialBufferSize);
             DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length * 2, initialBufferSize, testFile);){
            dfos.write(this.testBytes);
            Assertions.assertTrue((boolean)dfos.isInMemory());
            Assertions.assertThrows(IOException.class, () -> dfos.writeTo(baos));
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            dfos.close();
            dfos.writeTo(baos);
            byte[] copiedBytes = baos.toByteArray();
            Assertions.assertArrayEquals((byte[])this.testBytes, (byte[])copiedBytes);
        }
    }

    private void verifyResultFile(File testFile) throws IOException {
        try (InputStream fis = Files.newInputStream(testFile.toPath(), new OpenOption[0]);){
            Assertions.assertEquals((int)this.testBytes.length, (int)fis.available());
            byte[] resultBytes = new byte[this.testBytes.length];
            Assertions.assertEquals((int)this.testBytes.length, (int)fis.read(resultBytes));
            Assertions.assertArrayEquals((byte[])resultBytes, (byte[])this.testBytes);
            Assertions.assertEquals((int)-1, (int)fis.read(resultBytes));
        }
    }
}

