/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.commons.io.input.SequenceReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SequenceReaderTest {
    private static final char NUL = '\u0000';

    private void checkArray(char[] expected, char[] actual) {
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((char)expected[i], (char)actual[i], (String)("Compare[" + i + "]"));
        }
    }

    private void checkRead(Reader reader, String expected) throws IOException {
        for (int i = 0; i < expected.length(); ++i) {
            Assertions.assertEquals((char)expected.charAt(i), (char)((char)reader.read()), (String)("Read[" + i + "] of '" + expected + "'"));
        }
    }

    private void checkReadEof(Reader reader) throws IOException {
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testAutoClose() throws IOException {
        try (SequenceReader reader = new SequenceReader(new CharSequenceReader("FooBar"));){
            this.checkRead(reader, "Foo");
            ((Reader)reader).close();
            this.checkReadEof(reader);
        }
    }

    @Test
    public void testClose() throws IOException {
        SequenceReader reader = new SequenceReader(new CharSequenceReader("FooBar"));
        this.checkRead(reader, "Foo");
        ((Reader)reader).close();
        this.checkReadEof(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseReaders() throws IOException {
        CustomReader reader0 = new CustomReader();
        CustomReader reader1 = new CustomReader(){
            private final char[] content = new char[]{'A'};
            private int position;

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                this.checkOpen();
                if (off < 0) {
                    throw new IndexOutOfBoundsException("off is negative");
                }
                if (len < 0) {
                    throw new IndexOutOfBoundsException("len is negative");
                }
                if (len > cbuf.length - off) {
                    throw new IndexOutOfBoundsException("len is greater than cbuf.length - off");
                }
                if (this.position > 0) {
                    return -1;
                }
                cbuf[off] = this.content[0];
                ++this.position;
                return 1;
            }
        };
        try (SequenceReader sequenceReader = new SequenceReader(reader1, reader0);){
            Assertions.assertEquals((int)65, (int)sequenceReader.read());
            Assertions.assertEquals((int)-1, (int)sequenceReader.read());
        }
        finally {
            Assertions.assertTrue((boolean)reader1.isClosed());
            Assertions.assertTrue((boolean)reader0.isClosed());
        }
        Assertions.assertTrue((boolean)reader1.isClosed());
        Assertions.assertTrue((boolean)reader0.isClosed());
    }

    @Test
    public void testMarkSupported() throws Exception {
        try (SequenceReader reader = new SequenceReader(new Reader[0]);){
            Assertions.assertFalse((boolean)reader.markSupported());
        }
    }

    @Test
    public void testRead() throws IOException {
        try (SequenceReader reader = new SequenceReader(new StringReader("Foo"), new StringReader("Bar"));){
            Assertions.assertEquals((int)70, (int)((Reader)reader).read());
            Assertions.assertEquals((int)111, (int)((Reader)reader).read());
            Assertions.assertEquals((int)111, (int)((Reader)reader).read());
            Assertions.assertEquals((int)66, (int)((Reader)reader).read());
            Assertions.assertEquals((int)97, (int)((Reader)reader).read());
            Assertions.assertEquals((int)114, (int)((Reader)reader).read());
            this.checkReadEof(reader);
        }
    }

    @Test
    public void testReadCharArray() throws IOException {
        try (SequenceReader reader = new SequenceReader(new StringReader("Foo"), new StringReader("Bar"));){
            char[] chars = new char[2];
            Assertions.assertEquals((int)2, (int)reader.read(chars));
            this.checkArray(new char[]{'F', 'o'}, chars);
            chars = new char[3];
            Assertions.assertEquals((int)3, (int)reader.read(chars));
            this.checkArray(new char[]{'o', 'B', 'a'}, chars);
            chars = new char[3];
            Assertions.assertEquals((int)1, (int)reader.read(chars));
            this.checkArray(new char[]{'r', '\u0000', '\u0000'}, chars);
            Assertions.assertEquals((int)-1, (int)reader.read(chars));
        }
    }

    @Test
    public void testReadCharArrayPortion() throws IOException {
        char[] chars = new char[10];
        try (SequenceReader reader = new SequenceReader(new StringReader("Foo"), new StringReader("Bar"));){
            Assertions.assertEquals((int)3, (int)((Reader)reader).read(chars, 3, 3));
            this.checkArray(new char[]{'\u0000', '\u0000', '\u0000', 'F', 'o', 'o'}, chars);
            Assertions.assertEquals((int)3, (int)((Reader)reader).read(chars, 0, 3));
            this.checkArray(new char[]{'B', 'a', 'r', 'F', 'o', 'o', '\u0000'}, chars);
            Assertions.assertEquals((int)-1, (int)reader.read(chars));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> reader.read(chars, 10, 10));
            Assertions.assertThrows(NullPointerException.class, () -> reader.read(null, 0, 10));
        }
    }

    @Test
    public void testReadClosedReader() throws IOException {
        SequenceReader reader = new SequenceReader(new CharSequenceReader("FooBar"));
        ((Reader)reader).close();
        this.checkReadEof(reader);
    }

    @Test
    public void testReadCollection() throws IOException {
        ArrayList<StringReader> readers = new ArrayList<StringReader>();
        readers.add(new StringReader("F"));
        readers.add(new StringReader("B"));
        try (SequenceReader reader = new SequenceReader(readers);){
            Assertions.assertEquals((int)70, (int)((Reader)reader).read());
            Assertions.assertEquals((int)66, (int)((Reader)reader).read());
            this.checkReadEof(reader);
        }
    }

    @Test
    public void testReadIterable() throws IOException {
        ArrayList<StringReader> readers = new ArrayList<StringReader>();
        readers.add(new StringReader("F"));
        readers.add(new StringReader("B"));
        ArrayList<StringReader> iterable = readers;
        try (SequenceReader reader = new SequenceReader(iterable);){
            Assertions.assertEquals((int)70, (int)((Reader)reader).read());
            Assertions.assertEquals((int)66, (int)((Reader)reader).read());
            this.checkReadEof(reader);
        }
    }

    @Test
    public void testReadLength0Readers() throws IOException {
        try (SequenceReader reader = new SequenceReader(new StringReader(""), new StringReader(""), new StringReader(""));){
            this.checkReadEof(reader);
        }
    }

    @Test
    public void testReadLength1Readers() throws IOException {
        try (SequenceReader reader = new SequenceReader(new StringReader("0"), new StringReader("1"), new StringReader("2"), new StringReader("3"));){
            Assertions.assertEquals((int)48, (int)((Reader)reader).read());
            Assertions.assertEquals((int)49, (int)((Reader)reader).read());
            Assertions.assertEquals((int)50, (int)((Reader)reader).read());
            Assertions.assertEquals((int)51, (int)((Reader)reader).read());
        }
    }

    @Test
    public void testReadList() throws IOException {
        ArrayList<StringReader> readers = new ArrayList<StringReader>();
        readers.add(new StringReader("F"));
        readers.add(new StringReader("B"));
        try (SequenceReader reader = new SequenceReader(readers);){
            Assertions.assertEquals((int)70, (int)((Reader)reader).read());
            Assertions.assertEquals((int)66, (int)((Reader)reader).read());
            this.checkReadEof(reader);
        }
    }

    @Test
    public void testSkip() throws IOException {
        try (SequenceReader reader = new SequenceReader(new StringReader("Foo"), new StringReader("Bar"));){
            Assertions.assertEquals((long)3L, (long)reader.skip(3L));
            this.checkRead(reader, "Bar");
            Assertions.assertEquals((long)0L, (long)reader.skip(3L));
        }
    }

    private static class CustomReader
    extends Reader {
        boolean closed;

        private CustomReader() {
        }

        protected void checkOpen() throws IOException {
            if (this.closed) {
                throw new IOException("emptyReader already closed");
            }
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            this.checkOpen();
            this.close();
            return -1;
        }
    }
}

