package org.openqa.selenium.devtools.v139.performancetimeline.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * See https://wicg.github.io/layout-instability/#sec-layout-shift and layout_shift.idl
 */
public class LayoutShift {

    private final java.lang.Number value;

    private final java.lang.Boolean hadRecentInput;

    private final org.openqa.selenium.devtools.v139.network.model.TimeSinceEpoch lastInputTime;

    private final java.util.List<org.openqa.selenium.devtools.v139.performancetimeline.model.LayoutShiftAttribution> sources;

    public LayoutShift(java.lang.Number value, java.lang.Boolean hadRecentInput, org.openqa.selenium.devtools.v139.network.model.TimeSinceEpoch lastInputTime, java.util.List<org.openqa.selenium.devtools.v139.performancetimeline.model.LayoutShiftAttribution> sources) {
        this.value = java.util.Objects.requireNonNull(value, "value is required");
        this.hadRecentInput = java.util.Objects.requireNonNull(hadRecentInput, "hadRecentInput is required");
        this.lastInputTime = java.util.Objects.requireNonNull(lastInputTime, "lastInputTime is required");
        this.sources = java.util.Objects.requireNonNull(sources, "sources is required");
    }

    /**
     * Score increment produced by this event.
     */
    public java.lang.Number getValue() {
        return value;
    }

    public java.lang.Boolean getHadRecentInput() {
        return hadRecentInput;
    }

    public org.openqa.selenium.devtools.v139.network.model.TimeSinceEpoch getLastInputTime() {
        return lastInputTime;
    }

    public java.util.List<org.openqa.selenium.devtools.v139.performancetimeline.model.LayoutShiftAttribution> getSources() {
        return sources;
    }

    private static LayoutShift fromJson(JsonInput input) {
        java.lang.Number value = 0;
        java.lang.Boolean hadRecentInput = false;
        org.openqa.selenium.devtools.v139.network.model.TimeSinceEpoch lastInputTime = null;
        java.util.List<org.openqa.selenium.devtools.v139.performancetimeline.model.LayoutShiftAttribution> sources = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "value":
                    value = input.nextNumber();
                    break;
                case "hadRecentInput":
                    hadRecentInput = input.nextBoolean();
                    break;
                case "lastInputTime":
                    lastInputTime = input.read(org.openqa.selenium.devtools.v139.network.model.TimeSinceEpoch.class);
                    break;
                case "sources":
                    sources = input.readArray(org.openqa.selenium.devtools.v139.performancetimeline.model.LayoutShiftAttribution.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LayoutShift(value, hadRecentInput, lastInputTime, sources);
    }
}
