/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.Directive;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLAppliedDirective
implements GraphQLNamedSchemaElement {
    private final String name;
    private final ImmutableList<GraphQLAppliedDirectiveArgument> arguments;
    private final Directive definition;
    public static final String CHILD_ARGUMENTS = "arguments";

    private GraphQLAppliedDirective(String name, Directive definition, List<GraphQLAppliedDirectiveArgument> arguments) {
        Assert.assertValidName(name);
        Assert.assertNotNull(arguments, () -> "arguments can't be null");
        this.name = name;
        this.arguments = ImmutableList.copyOf(arguments);
        this.definition = definition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return null;
    }

    public List<GraphQLAppliedDirectiveArgument> getArguments() {
        return this.arguments;
    }

    public GraphQLAppliedDirectiveArgument getArgument(String name) {
        for (GraphQLAppliedDirectiveArgument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    @Override
    public Directive getDefinition() {
        return this.definition;
    }

    public String toString() {
        return new StringJoiner(", ", GraphQLAppliedDirective.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("arguments=" + String.valueOf(this.arguments)).add("definition=" + String.valueOf(this.definition)).toString();
    }

    public GraphQLAppliedDirective transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLAppliedDirective.newDirective(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLAppliedDirective.newDirective(this).build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLAppliedDirective(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        return ImmutableList.copyOf(this.arguments);
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_ARGUMENTS, this.arguments).build();
    }

    @Override
    public GraphQLAppliedDirective withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceArguments(newChildren.getChildren(CHILD_ARGUMENTS)));
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public static Builder newDirective() {
        return new Builder();
    }

    public static Builder newDirective(GraphQLAppliedDirective existing) {
        return new Builder(existing);
    }

    public static class Builder
    extends GraphqlTypeBuilder<Builder> {
        private final Map<String, GraphQLAppliedDirectiveArgument> arguments = new LinkedHashMap<String, GraphQLAppliedDirectiveArgument>();
        private Directive definition;

        public Builder() {
        }

        public Builder(GraphQLAppliedDirective existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.arguments.putAll(FpKit.getByName(existing.getArguments(), GraphQLAppliedDirectiveArgument::getName));
        }

        public Builder argument(GraphQLAppliedDirectiveArgument argument) {
            Assert.assertNotNull(argument, () -> "argument must not be null");
            this.arguments.put(argument.getName(), argument);
            return this;
        }

        public Builder replaceArguments(List<GraphQLAppliedDirectiveArgument> arguments) {
            Assert.assertNotNull(arguments, () -> "arguments must not be null");
            this.arguments.clear();
            for (GraphQLAppliedDirectiveArgument argument : arguments) {
                this.arguments.put(argument.getName(), argument);
            }
            return this;
        }

        public Builder argument(UnaryOperator<GraphQLAppliedDirectiveArgument.Builder> builderFunction) {
            GraphQLAppliedDirectiveArgument.Builder builder = GraphQLAppliedDirectiveArgument.newArgument();
            builder = (GraphQLAppliedDirectiveArgument.Builder)builderFunction.apply(builder);
            return this.argument(builder);
        }

        public Builder argument(GraphQLAppliedDirectiveArgument.Builder builder) {
            return this.argument(builder.build());
        }

        public Builder clearArguments() {
            this.arguments.clear();
            return this;
        }

        public Builder definition(Directive definition) {
            this.definition = definition;
            return this;
        }

        public GraphQLAppliedDirective build() {
            return new GraphQLAppliedDirective(this.name, this.definition, this.sort(this.arguments, GraphQLAppliedDirective.class, GraphQLAppliedDirectiveArgument.class));
        }
    }
}

