/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.IORandomAccessFile;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.RandomAccessFiles;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class RandomAccessFileModeTest {
    private static final byte[] BYTES_FIXTURE = "Foo".getBytes(StandardCharsets.US_ASCII);
    private static final String FIXTURE = "test.txt";
    @TempDir
    public Path tempDir;

    private byte[] read(RandomAccessFile randomAccessFile) throws IOException {
        return RandomAccessFiles.read(randomAccessFile, 0L, (int)randomAccessFile.length());
    }

    @ParameterizedTest
    @EnumSource(value=RandomAccessFileMode.class)
    public void testCreateFile(RandomAccessFileMode randomAccessFileMode) throws IOException {
        byte[] expected = BYTES_FIXTURE;
        Path fixture = this.writeFixture(expected);
        try (RandomAccessFile randomAccessFile = randomAccessFileMode.create(fixture.toFile());){
            Assertions.assertArrayEquals((byte[])expected, (byte[])this.read(randomAccessFile));
        }
    }

    @ParameterizedTest
    @EnumSource(value=RandomAccessFileMode.class)
    public void testCreatePath(RandomAccessFileMode randomAccessFileMode) throws IOException {
        byte[] expected = BYTES_FIXTURE;
        Path fixture = this.writeFixture(expected);
        randomAccessFileMode.accept(fixture, raf -> Assertions.assertArrayEquals((byte[])expected, (byte[])this.read((RandomAccessFile)raf)));
    }

    @ParameterizedTest
    @EnumSource(value=RandomAccessFileMode.class)
    public void testCreateString(RandomAccessFileMode randomAccessFileMode) throws IOException {
        byte[] expected = BYTES_FIXTURE;
        Path fixture = this.writeFixture(expected);
        try (RandomAccessFile randomAccessFile = randomAccessFileMode.create(fixture.toString());){
            Assertions.assertArrayEquals((byte[])expected, (byte[])this.read(randomAccessFile));
        }
    }

    @Test
    public void testGetMode() {
        Assertions.assertEquals((Object)"r", (Object)RandomAccessFileMode.READ_ONLY.getMode());
        Assertions.assertEquals((Object)"rw", (Object)RandomAccessFileMode.READ_WRITE.getMode());
        Assertions.assertEquals((Object)"rwd", (Object)RandomAccessFileMode.READ_WRITE_SYNC_CONTENT.getMode());
        Assertions.assertEquals((Object)"rws", (Object)RandomAccessFileMode.READ_WRITE_SYNC_ALL.getMode());
    }

    @Test
    public void testImplies() {
        Assertions.assertTrue((boolean)RandomAccessFileMode.READ_WRITE_SYNC_ALL.implies(RandomAccessFileMode.READ_WRITE_SYNC_CONTENT));
        Assertions.assertTrue((boolean)RandomAccessFileMode.READ_WRITE_SYNC_CONTENT.implies(RandomAccessFileMode.READ_WRITE));
        Assertions.assertTrue((boolean)RandomAccessFileMode.READ_WRITE.implies(RandomAccessFileMode.READ_ONLY));
        Assertions.assertFalse((boolean)RandomAccessFileMode.READ_ONLY.implies(RandomAccessFileMode.READ_WRITE_SYNC_ALL));
    }

    @ParameterizedTest
    @EnumSource(value=RandomAccessFileMode.class)
    public void testIoString(RandomAccessFileMode randomAccessFileMode) throws IOException {
        byte[] expected = BYTES_FIXTURE;
        Path fixture = this.writeFixture(expected);
        try (IORandomAccessFile randomAccessFile = randomAccessFileMode.io(fixture.toString());){
            Assertions.assertArrayEquals((byte[])expected, (byte[])this.read(randomAccessFile));
        }
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"READ_ONLY", (Object)RandomAccessFileMode.READ_ONLY.toString());
        Assertions.assertEquals((Object)"READ_WRITE", (Object)RandomAccessFileMode.READ_WRITE.toString());
        Assertions.assertEquals((Object)"READ_WRITE_SYNC_ALL", (Object)RandomAccessFileMode.READ_WRITE_SYNC_ALL.toString());
        Assertions.assertEquals((Object)"READ_WRITE_SYNC_CONTENT", (Object)RandomAccessFileMode.READ_WRITE_SYNC_CONTENT.toString());
    }

    @ParameterizedTest
    @EnumSource(value=LinkOption.class)
    public void testValueOf(LinkOption option) {
        Assertions.assertTrue((boolean)RandomAccessFileMode.valueOf(option).implies(RandomAccessFileMode.READ_ONLY));
    }

    @ParameterizedTest
    @EnumSource(value=StandardOpenOption.class)
    public void testValueOf(StandardOpenOption option) {
        Assertions.assertTrue((boolean)RandomAccessFileMode.valueOf(option).implies(RandomAccessFileMode.READ_ONLY));
    }

    @Test
    public void testValueOfMode() {
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_ONLY), (Object)((Object)RandomAccessFileMode.valueOfMode("r")));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE), (Object)((Object)RandomAccessFileMode.valueOfMode("rw")));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE_SYNC_CONTENT), (Object)((Object)RandomAccessFileMode.valueOfMode("rwd")));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE_SYNC_ALL), (Object)((Object)RandomAccessFileMode.valueOfMode("rws")));
    }

    @Test
    public void testValueOfOpenOptions() {
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_ONLY), (Object)((Object)RandomAccessFileMode.valueOf(StandardOpenOption.READ)));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE), (Object)((Object)RandomAccessFileMode.valueOf(StandardOpenOption.WRITE)));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE), (Object)((Object)RandomAccessFileMode.valueOf(StandardOpenOption.READ, StandardOpenOption.WRITE)));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE_SYNC_CONTENT), (Object)((Object)RandomAccessFileMode.valueOf(StandardOpenOption.DSYNC)));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE_SYNC_CONTENT), (Object)((Object)RandomAccessFileMode.valueOf(StandardOpenOption.WRITE, StandardOpenOption.DSYNC)));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE_SYNC_CONTENT), (Object)((Object)RandomAccessFileMode.valueOf(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC)));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE_SYNC_ALL), (Object)((Object)RandomAccessFileMode.valueOf(StandardOpenOption.SYNC)));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE_SYNC_ALL), (Object)((Object)RandomAccessFileMode.valueOf(StandardOpenOption.READ, StandardOpenOption.SYNC)));
        Assertions.assertEquals((Object)((Object)RandomAccessFileMode.READ_WRITE_SYNC_ALL), (Object)((Object)RandomAccessFileMode.valueOf(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SYNC)));
    }

    private Path writeFixture(byte[] bytes) throws IOException {
        return Files.write(this.tempDir.resolve(FIXTURE), bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

