/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.LazyObjectBinding;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.util.Subscription;

public class MappedBinding<S, T>
extends LazyObjectBinding<T> {
    private final ObservableValue<S> source;
    private final Function<? super S, ? extends T> mapper;

    public MappedBinding(ObservableValue<S> observableValue, Function<? super S, ? extends T> function) {
        this.source = Objects.requireNonNull(observableValue, "source cannot be null");
        this.mapper = Objects.requireNonNull(function, "mapper cannot be null");
    }

    @Override
    protected T computeValue() {
        S s2 = this.source.getValue();
        return s2 == null ? null : (T)this.mapper.apply((S)s2);
    }

    @Override
    protected Subscription observeSources() {
        return this.source.subscribe(this::invalidate);
    }
}

