package org.openqa.selenium.devtools.v141.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Sets Controls for IP Proxy of requests.
 * Page reload is required before the new behavior will be observed.
 */
@org.openqa.selenium.Beta()
public enum IpProxyStatus {

    AVAILABLE("Available"),
    FEATURENOTENABLED("FeatureNotEnabled"),
    MASKEDDOMAINLISTNOTENABLED("MaskedDomainListNotEnabled"),
    MASKEDDOMAINLISTNOTPOPULATED("MaskedDomainListNotPopulated"),
    AUTHTOKENSUNAVAILABLE("AuthTokensUnavailable"),
    UNAVAILABLE("Unavailable"),
    BYPASSEDBYDEVTOOLS("BypassedByDevTools");

    private String value;

    IpProxyStatus(String value) {
        this.value = value;
    }

    public static IpProxyStatus fromString(String s) {
        return java.util.Arrays.stream(IpProxyStatus.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within IpProxyStatus "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static IpProxyStatus fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
