package org.openqa.selenium.devtools.v140.pwa.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The following types are the replica of
 * https://crsrc.org/c/chrome/browser/web_applications/proto/web_app_os_integration_state.proto;drc=9910d3be894c8f142c977ba1023f30a656bc13fc;l=67
 */
public class FileHandlerAccept {

    private final java.lang.String mediaType;

    private final java.util.List<java.lang.String> fileExtensions;

    public FileHandlerAccept(java.lang.String mediaType, java.util.List<java.lang.String> fileExtensions) {
        this.mediaType = java.util.Objects.requireNonNull(mediaType, "mediaType is required");
        this.fileExtensions = java.util.Objects.requireNonNull(fileExtensions, "fileExtensions is required");
    }

    /**
     * New name of the mimetype according to
     * https://www.iana.org/assignments/media-types/media-types.xhtml
     */
    public java.lang.String getMediaType() {
        return mediaType;
    }

    public java.util.List<java.lang.String> getFileExtensions() {
        return fileExtensions;
    }

    private static FileHandlerAccept fromJson(JsonInput input) {
        java.lang.String mediaType = null;
        java.util.List<java.lang.String> fileExtensions = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "mediaType":
                    mediaType = input.nextString();
                    break;
                case "fileExtensions":
                    fileExtensions = input.readArray(java.lang.String.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FileHandlerAccept(mediaType, fileExtensions);
    }
}
