/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac;

import net.sourceforge.jaad.aac.AACDecoderConfig;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.ChannelConfiguration;
import net.sourceforge.jaad.aac.Profile;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.aac.filterbank.FilterBank;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.aac.syntax.IBitStream;
import net.sourceforge.jaad.aac.syntax.PCE;
import net.sourceforge.jaad.aac.syntax.SyntacticElements;
import net.sourceforge.jaad.aac.syntax.SyntaxConstants;
import net.sourceforge.jaad.aac.transport.ADIFHeader;
import org.jcodec.common.logging.Logger;

public class Decoder
implements SyntaxConstants {
    private final AACDecoderConfig config;
    private final SyntacticElements syntacticElements;
    private final FilterBank filterBank;
    private IBitStream _in;
    private ADIFHeader adifHeader;

    public static boolean canDecode(Profile profile) {
        return profile.isDecodingSupported();
    }

    public Decoder(byte[] decoderSpecificInfo) throws AACException {
        this.config = AACDecoderConfig.parseMP4DecoderSpecificInfo(decoderSpecificInfo);
        if (this.config == null) {
            throw new IllegalArgumentException("illegal MP4 decoder specific info");
        }
        if (!Decoder.canDecode(this.config.getProfile())) {
            throw new AACException("unsupported profile: " + this.config.getProfile().getDescription());
        }
        this.syntacticElements = new SyntacticElements(this.config);
        this.filterBank = new FilterBank(this.config.isSmallFrameUsed(), this.config.getChannelConfiguration().getChannelCount());
        this._in = new BitStream();
        Logger.debug("profile: {0}", this.config.getProfile());
        Logger.debug("sf: {0}", this.config.getSampleFrequency().getFrequency());
        Logger.debug("channels: {0}", this.config.getChannelConfiguration().getDescription());
    }

    public AACDecoderConfig getConfig() {
        return this.config;
    }

    public void decodeFrame(byte[] frame, SampleBuffer buffer) throws AACException {
        if (frame != null) {
            this._in.setData(frame);
        }
        Logger.debug("bits left " + this._in.getBitsLeft());
        try {
            this.decode(buffer);
        }
        catch (AACException e) {
            if (!e.isEndOfStream()) {
                throw e;
            }
            Logger.warn("unexpected end of frame");
        }
    }

    private void decode(SampleBuffer buffer) throws AACException {
        if (ADIFHeader.isPresent(this._in)) {
            this.adifHeader = ADIFHeader.readHeader(this._in);
            PCE pce = this.adifHeader.getFirstPCE();
            this.config.setProfile(pce.getProfile());
            this.config.setSampleFrequency(pce.getSampleFrequency());
            this.config.setChannelConfiguration(ChannelConfiguration.forInt(pce.getChannelCount()));
        }
        if (!Decoder.canDecode(this.config.getProfile())) {
            throw new AACException("unsupported profile: " + this.config.getProfile().getDescription());
        }
        this.syntacticElements.startNewFrame();
        try {
            this.syntacticElements.decode(this._in);
            this.syntacticElements.process(this.filterBank);
            this.syntacticElements.sendToOutput(buffer);
        }
        catch (Exception e) {
            buffer.setData(new byte[0], 0, 0, 0, 0);
            throw AACException.wrap(e);
        }
    }
}

