/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.utils.Converters;

public class GraphicalCodeDetector {
    protected final long nativeObj;

    protected GraphicalCodeDetector(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static GraphicalCodeDetector __fromPtr__(long addr) {
        return new GraphicalCodeDetector(addr);
    }

    public boolean detect(Mat img, Mat points) {
        return GraphicalCodeDetector.detect_0(this.nativeObj, img.nativeObj, points.nativeObj);
    }

    public String decode(Mat img, Mat points, Mat straight_code) {
        return GraphicalCodeDetector.decode_0(this.nativeObj, img.nativeObj, points.nativeObj, straight_code.nativeObj);
    }

    public String decode(Mat img, Mat points) {
        return GraphicalCodeDetector.decode_1(this.nativeObj, img.nativeObj, points.nativeObj);
    }

    public String detectAndDecode(Mat img, Mat points, Mat straight_code) {
        return GraphicalCodeDetector.detectAndDecode_0(this.nativeObj, img.nativeObj, points.nativeObj, straight_code.nativeObj);
    }

    public String detectAndDecode(Mat img, Mat points) {
        return GraphicalCodeDetector.detectAndDecode_1(this.nativeObj, img.nativeObj, points.nativeObj);
    }

    public String detectAndDecode(Mat img) {
        return GraphicalCodeDetector.detectAndDecode_2(this.nativeObj, img.nativeObj);
    }

    public boolean detectMulti(Mat img, Mat points) {
        return GraphicalCodeDetector.detectMulti_0(this.nativeObj, img.nativeObj, points.nativeObj);
    }

    public boolean decodeMulti(Mat img, Mat points, List<String> decoded_info, List<Mat> straight_code) {
        Mat straight_code_mat = new Mat();
        boolean retVal = GraphicalCodeDetector.decodeMulti_0(this.nativeObj, img.nativeObj, points.nativeObj, decoded_info, straight_code_mat.nativeObj);
        Converters.Mat_to_vector_Mat(straight_code_mat, straight_code);
        straight_code_mat.release();
        return retVal;
    }

    public boolean decodeMulti(Mat img, Mat points, List<String> decoded_info) {
        return GraphicalCodeDetector.decodeMulti_1(this.nativeObj, img.nativeObj, points.nativeObj, decoded_info);
    }

    public boolean detectAndDecodeMulti(Mat img, List<String> decoded_info, Mat points, List<Mat> straight_code) {
        Mat straight_code_mat = new Mat();
        boolean retVal = GraphicalCodeDetector.detectAndDecodeMulti_0(this.nativeObj, img.nativeObj, decoded_info, points.nativeObj, straight_code_mat.nativeObj);
        Converters.Mat_to_vector_Mat(straight_code_mat, straight_code);
        straight_code_mat.release();
        return retVal;
    }

    public boolean detectAndDecodeMulti(Mat img, List<String> decoded_info, Mat points) {
        return GraphicalCodeDetector.detectAndDecodeMulti_1(this.nativeObj, img.nativeObj, decoded_info, points.nativeObj);
    }

    public boolean detectAndDecodeMulti(Mat img, List<String> decoded_info) {
        return GraphicalCodeDetector.detectAndDecodeMulti_2(this.nativeObj, img.nativeObj, decoded_info);
    }

    protected void finalize() throws Throwable {
        GraphicalCodeDetector.delete(this.nativeObj);
    }

    private static native boolean detect_0(long var0, long var2, long var4);

    private static native String decode_0(long var0, long var2, long var4, long var6);

    private static native String decode_1(long var0, long var2, long var4);

    private static native String detectAndDecode_0(long var0, long var2, long var4, long var6);

    private static native String detectAndDecode_1(long var0, long var2, long var4);

    private static native String detectAndDecode_2(long var0, long var2);

    private static native boolean detectMulti_0(long var0, long var2, long var4);

    private static native boolean decodeMulti_0(long var0, long var2, long var4, List<String> var6, long var7);

    private static native boolean decodeMulti_1(long var0, long var2, long var4, List<String> var6);

    private static native boolean detectAndDecodeMulti_0(long var0, long var2, List<String> var4, long var5, long var7);

    private static native boolean detectAndDecodeMulti_1(long var0, long var2, List<String> var4, long var5);

    private static native boolean detectAndDecodeMulti_2(long var0, long var2, List<String> var4);

    private static native void delete(long var0);
}

