/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import org.apache.commons.io.output.BrokenWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class BrokenWriterTest {
    BrokenWriterTest() {
    }

    private static BrokenWriter createBrokenWriter(Throwable exception) {
        if (exception instanceof IOException) {
            return new BrokenWriter((IOException)exception);
        }
        return new BrokenWriter(exception);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testAppendChar(Class<Exception> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenWriter brokenWriter = BrokenWriterTest.createBrokenWriter(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenWriter.append('1')));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testAppendCharSequence(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenWriter brokenWriter = BrokenWriterTest.createBrokenWriter(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenWriter.append((CharSequence)"01")));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testAppendCharSequenceIndexed(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenWriter brokenWriter = BrokenWriterTest.createBrokenWriter(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenWriter.append((CharSequence)"01", 0, 1)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testClose(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenWriter brokenWriter = BrokenWriterTest.createBrokenWriter(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenWriter.close()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testFlush(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenWriter brokenWriter = BrokenWriterTest.createBrokenWriter(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenWriter.flush()));
    }

    @Test
    void testInstance() {
        Assertions.assertNotNull((Object)BrokenWriter.INSTANCE);
    }

    @Test
    void testTryWithResources() {
        IOException thrown = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (BrokenWriter newWriter = new BrokenWriter();){
                newWriter.write(1);
            }
        });
        Assertions.assertEquals((Object)"Broken writer", (Object)thrown.getMessage());
        Throwable[] suppressed = thrown.getSuppressed();
        Assertions.assertEquals((int)1, (int)suppressed.length);
        Assertions.assertEquals(IOException.class, suppressed[0].getClass());
        Assertions.assertEquals((Object)"Broken writer", (Object)suppressed[0].getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testWriteCharArray(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenWriter brokenWriter = BrokenWriterTest.createBrokenWriter(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenWriter.write(new char[1])));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testWriteCharArrayIndexed(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenWriter brokenWriter = BrokenWriterTest.createBrokenWriter(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenWriter.write(new char[1], 0, 1)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testWriteInt(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenWriter brokenWriter = BrokenWriterTest.createBrokenWriter(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenWriter.write(1)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testWriteString(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenWriter brokenWriter = BrokenWriterTest.createBrokenWriter(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenWriter.write("01")));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testWriteStringIndexed(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenWriter brokenWriter = BrokenWriterTest.createBrokenWriter(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenWriter.write("01", 0, 1)));
    }
}

