/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.webextension;

import java.lang.reflect.Type;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.webextension.InstallExtensionParameters;
import org.openqa.selenium.bidi.webextension.UninstallExtensionParameters;
import org.openqa.selenium.internal.Require;

public class WebExtension {
    private final BiDi bidi;

    public WebExtension(WebDriver driver) {
        Require.nonNull("WebDriver", driver);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)((Object)driver)).getBiDi();
    }

    public Map<String, Object> install(InstallExtensionParameters parameters) {
        Require.nonNull("Install parameters", parameters);
        return (Map)this.bidi.send(new Command("webExtension.install", parameters.getExtensionData().toMap(), (Type)((Object)Map.class)));
    }

    public Map<String, Object> uninstall(UninstallExtensionParameters parameters) {
        Require.nonNull("Uninstall parameters", parameters);
        return (Map)this.bidi.send(new Command("webExtension.uninstall", parameters.extension, (Type)((Object)Map.class)));
    }
}

