/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorHelper;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.language.SourceLocation;
import graphql.validation.ValidationErrorClassification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@PublicApi
public class ValidationError
implements GraphQLError {
    private final List<SourceLocation> locations = new ArrayList<SourceLocation>();
    private final String description;
    private final ValidationErrorClassification validationErrorType;
    private final List<String> queryPath = new ArrayList<String>();
    private final ImmutableMap<String, Object> extensions;

    private ValidationError(Builder builder) {
        this.validationErrorType = builder.validationErrorType;
        this.description = builder.description;
        if (builder.sourceLocations != null) {
            this.locations.addAll(builder.sourceLocations);
        }
        if (builder.queryPath != null) {
            this.queryPath.addAll(builder.queryPath);
        }
        this.extensions = builder.extensions != null ? ImmutableMap.copyOf(builder.extensions) : ImmutableMap.of();
    }

    public ValidationErrorClassification getValidationErrorType() {
        return this.validationErrorType;
    }

    @Override
    public String getMessage() {
        return this.description;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    @Override
    public ErrorType getErrorType() {
        return ErrorType.ValidationError;
    }

    public List<String> getQueryPath() {
        return this.queryPath;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public String toString() {
        String extensionsString = "";
        if (this.extensions.size() > 0) {
            extensionsString = this.extensions.keySet().stream().map(key -> key + "=" + String.valueOf(this.extensions.get(key))).collect(Collectors.joining(", "));
        }
        return "ValidationError{validationErrorType=" + String.valueOf(this.validationErrorType) + ", queryPath=" + String.valueOf(this.queryPath) + ", message=" + this.description + ", locations=" + String.valueOf(this.locations) + ", description='" + this.description + "', extensions=[" + extensionsString + "]}";
    }

    public boolean equals(Object o) {
        return GraphqlErrorHelper.equals(this, o);
    }

    public int hashCode() {
        return GraphqlErrorHelper.hashCode(this);
    }

    public static Builder newValidationError() {
        return new Builder();
    }

    public static class Builder {
        private List<SourceLocation> sourceLocations;
        private Map<String, Object> extensions;
        private String description;
        private ValidationErrorClassification validationErrorType;
        private List<String> queryPath;

        public Builder validationErrorType(ValidationErrorClassification validationErrorType) {
            this.validationErrorType = validationErrorType;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder queryPath(List<String> queryPath) {
            this.queryPath = queryPath;
            return this;
        }

        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocations = sourceLocation == null ? null : Collections.singletonList(sourceLocation);
            return this;
        }

        public Builder sourceLocations(List<SourceLocation> sourceLocations) {
            this.sourceLocations = sourceLocations;
            return this;
        }

        public Builder extensions(Map<String, Object> extensions) {
            this.extensions = extensions;
            return this;
        }

        public ValidationError build() {
            return new ValidationError(this);
        }
    }
}

