/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.IntValue;
import graphql.language.Value;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public class GraphqlIntCoercing
implements Coercing<Integer, Integer> {
    private static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);

    private Integer convertImpl(Object input) {
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
            try {
                return value.intValueExact();
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        return null;
    }

    private @NonNull Integer serialiseImpl(Object input, @NonNull Locale locale) {
        Integer result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException(CoercingUtil.i18nMsg(locale, "Int.notInt", CoercingUtil.typeName(input)));
        }
        return result;
    }

    private @NonNull Integer parseValueImpl(@NonNull Object input, @NonNull Locale locale) {
        if (!(input instanceof Number)) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "Int.notInt", CoercingUtil.typeName(input)));
        }
        if (input instanceof Integer) {
            return (Integer)input;
        }
        BigInteger result = this.convertParseValueImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "Int.notInt", CoercingUtil.typeName(input)));
        }
        if (result.compareTo(INT_MIN) < 0 || result.compareTo(INT_MAX) > 0) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "Int.outsideRange", result.toString()));
        }
        return result.intValueExact();
    }

    private BigInteger convertParseValueImpl(Object input) {
        BigDecimal value;
        try {
            value = new BigDecimal(input.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
        try {
            return value.toBigIntegerExact();
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    private static int parseLiteralImpl(Object input, @NonNull Locale locale) {
        if (!(input instanceof IntValue)) {
            throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "Scalar.unexpectedAstType", "IntValue", CoercingUtil.typeName(input)));
        }
        BigInteger value = ((IntValue)input).getValue();
        if (value.compareTo(INT_MIN) < 0 || value.compareTo(INT_MAX) > 0) {
            throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "Int.outsideRange", value.toString()));
        }
        return value.intValue();
    }

    private IntValue valueToLiteralImpl(Object input, @NonNull Locale locale) {
        Integer result = this.convertImpl(input);
        if (result == null) {
            Assert.assertShouldNeverHappen(CoercingUtil.i18nMsg(locale, "Int.notInt", CoercingUtil.typeName(input)), new Object[0]);
        }
        return IntValue.newIntValue(BigInteger.valueOf(result.intValue())).build();
    }

    @Override
    @Deprecated
    public Integer serialize(@NonNull Object dataFetcherResult) {
        return this.serialiseImpl(dataFetcherResult, Locale.getDefault());
    }

    @Override
    public @Nullable Integer serialize(@NonNull Object dataFetcherResult, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) throws CoercingSerializeException {
        return this.serialiseImpl(dataFetcherResult, locale);
    }

    @Override
    @Deprecated
    public Integer parseValue(@NonNull Object input) {
        return this.parseValueImpl(input, Locale.getDefault());
    }

    @Override
    public Integer parseValue(@NonNull Object input, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) throws CoercingParseValueException {
        return this.parseValueImpl(input, locale);
    }

    @Override
    @Deprecated
    public Integer parseLiteral(@NonNull Object input) {
        return GraphqlIntCoercing.parseLiteralImpl(input, Locale.getDefault());
    }

    @Override
    public @Nullable Integer parseLiteral(@NonNull Value<?> input, @NonNull CoercedVariables variables, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) throws CoercingParseLiteralException {
        return GraphqlIntCoercing.parseLiteralImpl(input, locale);
    }

    @Override
    @Deprecated
    public @NonNull Value<?> valueToLiteral(@NonNull Object input) {
        return this.valueToLiteralImpl(input, Locale.getDefault());
    }

    @Override
    public @NonNull Value<?> valueToLiteral(@NonNull Object input, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) {
        return this.valueToLiteralImpl(input, locale);
    }
}

