/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.execution.directives.QueryAppliedDirective;
import graphql.execution.directives.QueryAppliedDirectiveArgument;
import graphql.execution.directives.QueryDirectives;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.NormalizedInputValue;
import graphql.normalized.VariableAccumulator;
import graphql.normalized.VariableValueWithDefinition;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
class ArgumentMaker {
    ArgumentMaker() {
    }

    static List<Argument> createArguments(ExecutableNormalizedField executableNormalizedField, VariableAccumulator variableAccumulator) {
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableMap<String, NormalizedInputValue> normalizedArguments = executableNormalizedField.getNormalizedArguments();
        for (String argName : normalizedArguments.keySet()) {
            NormalizedInputValue normalizedInputValue = normalizedArguments.get(argName);
            Value<?> value = ArgumentMaker.argValue(executableNormalizedField, null, argName, normalizedInputValue, variableAccumulator);
            Argument argument = Argument.newArgument().name(argName).value(value).build();
            result.add(argument);
        }
        return result.build();
    }

    static List<Argument> createDirectiveArguments(ExecutableNormalizedField executableNormalizedField, QueryDirectives queryDirectives, QueryAppliedDirective queryAppliedDirective, VariableAccumulator variableAccumulator) {
        Map argValueMap = queryDirectives.getNormalizedInputValueByImmediateAppliedDirectives().getOrDefault(queryAppliedDirective, ImmutableKit.emptyMap());
        ImmutableList.Builder result = ImmutableList.builder();
        for (QueryAppliedDirectiveArgument directiveArgument : queryAppliedDirective.getArguments()) {
            String argName = directiveArgument.getName();
            if (argValueMap == null || !argValueMap.containsKey(argName)) continue;
            NormalizedInputValue normalizedInputValue = (NormalizedInputValue)argValueMap.get(argName);
            Value<?> value = ArgumentMaker.argValue(executableNormalizedField, queryAppliedDirective, argName, normalizedInputValue, variableAccumulator);
            Argument argument = Argument.newArgument().name(argName).value(value).build();
            result.add(argument);
        }
        return result.build();
    }

    private static Value<?> argValue(ExecutableNormalizedField executableNormalizedField, QueryAppliedDirective queryAppliedDirective, String argName, @Nullable Object value, VariableAccumulator variableAccumulator) {
        if (value instanceof List) {
            ArrayValue.Builder arrayValue = ArrayValue.newArrayValue();
            arrayValue.values(ImmutableKit.map((List)value, val -> ArgumentMaker.argValue(executableNormalizedField, queryAppliedDirective, argName, val, variableAccumulator)));
            return arrayValue.build();
        }
        if (value instanceof Map) {
            ObjectValue.Builder objectValue = ObjectValue.newObjectValue();
            Map map = (Map)value;
            for (String fieldName : map.keySet()) {
                Value<?> fieldValue = ArgumentMaker.argValue(executableNormalizedField, queryAppliedDirective, argName, (NormalizedInputValue)map.get(fieldName), variableAccumulator);
                objectValue.objectField(ObjectField.newObjectField().name(fieldName).value(fieldValue).build());
            }
            return objectValue.build();
        }
        if (value == null) {
            return NullValue.newNullValue().build();
        }
        return (Value)value;
    }

    private static @NonNull Value<?> argValue(ExecutableNormalizedField executableNormalizedField, QueryAppliedDirective queryAppliedDirective, String argName, NormalizedInputValue normalizedInputValue, VariableAccumulator variableAccumulator) {
        if (variableAccumulator.shouldMakeVariable(executableNormalizedField, queryAppliedDirective, argName, normalizedInputValue)) {
            VariableValueWithDefinition variableWithDefinition = variableAccumulator.accumulateVariable(normalizedInputValue);
            return variableWithDefinition.getVariableReference();
        }
        return ArgumentMaker.argValue(executableNormalizedField, queryAppliedDirective, argName, normalizedInputValue.getValue(), variableAccumulator);
    }
}

