/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

class TeeReader
extends Reader {
    private final Reader source;
    private final Writer[] sinks;

    public TeeReader(Reader source, Writer ... sinks) {
        this.source = source;
        this.sinks = sinks;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = this.source.read(cbuf, off, len);
        if (read != -1) {
            for (Writer sink : this.sinks) {
                sink.write(cbuf, off, read);
            }
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
        for (Writer sink : this.sinks) {
            sink.close();
        }
    }
}

