/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.docker;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.Device;
import org.openqa.selenium.docker.Docker;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.docker.DockerAssetsPath;
import org.openqa.selenium.grid.node.docker.DockerSessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.HostIdentifier;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.tracing.Tracer;

public class DockerOptions {
    static final String DOCKER_SECTION = "docker";
    static final String DEFAULT_ASSETS_PATH = "/opt/selenium/assets";
    static final String DEFAULT_DOCKER_URL = "unix:/var/run/docker.sock";
    static final String DEFAULT_VIDEO_IMAGE = "false";
    static final int DEFAULT_MAX_SESSIONS = Runtime.getRuntime().availableProcessors();
    private static final String DEFAULT_DOCKER_NETWORK = "bridge";
    private static final Logger LOG = Logger.getLogger(DockerOptions.class.getName());
    private static final Json JSON = new Json();
    private final Config config;

    public DockerOptions(Config config) {
        this.config = Require.nonNull("Config", config);
    }

    private URI getDockerUri() {
        try {
            Optional<String> possibleUri = this.config.get(DOCKER_SECTION, "url");
            if (possibleUri.isPresent()) {
                return new URI(possibleUri.get());
            }
            Optional<String> possibleHost = this.config.get(DOCKER_SECTION, "host");
            Optional<Integer> possiblePort = this.config.getInt(DOCKER_SECTION, "port");
            if (possibleHost.isPresent() && possiblePort.isPresent()) {
                String host = possibleHost.get();
                int port = possiblePort.get();
                host = !host.startsWith("tcp:") && !host.startsWith("http:") && !host.startsWith("https") ? String.format("http://%s:%s", host, port) : String.format("%s:%s", host, port);
                URI uri = new URI(host);
                return new URI("http", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            }
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                return new URI("http://localhost:2376");
            }
            return new URI(DEFAULT_DOCKER_URL);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Unable to determine docker url", new Object[]{e});
        }
    }

    private boolean isEnabled(Docker docker) {
        if (!this.config.getAll(DOCKER_SECTION, "configs").isPresent()) {
            return false;
        }
        return docker.isSupported();
    }

    public Map<Capabilities, Collection<SessionFactory>> getDockerSessionFactories(Tracer tracer, HttpClient.Factory clientFactory, NodeOptions options) {
        HttpClient client = clientFactory.createClient(ClientConfig.defaultConfig().baseUri(this.getDockerUri()));
        Docker docker = new Docker(client);
        if (!this.isEnabled(docker)) {
            throw new DockerException("Unable to reach the Docker daemon at " + String.valueOf(this.getDockerUri()));
        }
        List<String> allConfigs = this.config.getAll(DOCKER_SECTION, "configs").orElseThrow(() -> new DockerException("Unable to find docker configs"));
        List hostConfigKeys = this.config.getAll(DOCKER_SECTION, "host-config-keys").orElseGet(Collections::emptyList);
        HashMultimap<String, Capabilities> kinds = HashMultimap.create();
        for (int i = 0; i < allConfigs.size(); ++i) {
            String imageName = allConfigs.get(i);
            if (++i == allConfigs.size()) {
                throw new DockerException("Unable to find JSON config");
            }
            Capabilities stereotype = options.enhanceStereotype((Capabilities)JSON.toType(allConfigs.get(i), (Type)((Object)Capabilities.class)));
            kinds.put(imageName, stereotype);
        }
        List<Device> devicesMapping = this.getDevicesMapping();
        String hostname = HostIdentifier.getHostName();
        Optional<ContainerInfo> info = docker.inspect(new ContainerId(hostname));
        DockerAssetsPath assetsPath = this.getAssetsPath(info);
        String networkName = this.getDockerNetworkName(info);
        Map<String, Object> hostConfig = this.getDockerHostConfig(info);
        this.loadImages(docker, kinds.keySet().toArray(new String[0]));
        Image videoImage = this.getVideoImage(docker);
        if (videoImage != null) {
            this.loadImages(docker, videoImage.getName());
        }
        int maxContainerCount = Math.min(this.config.getInt("node", "max-sessions").orElse(DEFAULT_MAX_SESSIONS), DEFAULT_MAX_SESSIONS);
        ImmutableMultimap.Builder factories = ImmutableMultimap.builder();
        kinds.forEach((name, caps) -> {
            Image image = docker.getImage((String)name);
            for (int i = 0; i < maxContainerCount; ++i) {
                factories.put(caps, new DockerSessionFactory(tracer, clientFactory, options.getSessionTimeout(), docker, this.getDockerUri(), image, (Capabilities)caps, devicesMapping, videoImage, assetsPath, networkName, info.isPresent(), capabilities -> options.getSlotMatcher().matches((Capabilities)caps, (Capabilities)capabilities), hostConfig, hostConfigKeys));
            }
            LOG.info(String.format("Mapping %s to docker image %s %d times", caps, name, maxContainerCount));
        });
        return factories.build().asMap();
    }

    protected List<Device> getDevicesMapping() {
        Pattern linuxDeviceMappingWithDefaultPermissionsPattern = Pattern.compile("^([\\w\\/-]+):([\\w\\/-]+)$");
        Pattern linuxDeviceMappingWithPermissionsPattern = Pattern.compile("^([\\w\\/-]+):([\\w\\/-]+):([\\w]+)$");
        List devices = this.config.getAll(DOCKER_SECTION, "devices").orElseGet(Collections::emptyList);
        ArrayList<Device> deviceMapping = new ArrayList<Device>();
        for (String device : devices) {
            String deviceMappingDefined = device.trim();
            Matcher matcher = linuxDeviceMappingWithDefaultPermissionsPattern.matcher(deviceMappingDefined);
            if (matcher.matches()) {
                deviceMapping.add(Device.device(matcher.group(1), matcher.group(2), null));
                continue;
            }
            matcher = linuxDeviceMappingWithPermissionsPattern.matcher(deviceMappingDefined);
            if (!matcher.matches()) continue;
            deviceMapping.add(Device.device(matcher.group(1), matcher.group(2), matcher.group(3)));
        }
        return deviceMapping;
    }

    private Image getVideoImage(Docker docker) {
        String videoImage = this.config.get(DOCKER_SECTION, "video-image").orElse(DEFAULT_VIDEO_IMAGE);
        if (videoImage.equalsIgnoreCase(DEFAULT_VIDEO_IMAGE)) {
            return null;
        }
        return docker.getImage(videoImage);
    }

    private String getDockerNetworkName(Optional<ContainerInfo> info) {
        if (info.isPresent()) {
            return info.get().getNetworkName();
        }
        return DEFAULT_DOCKER_NETWORK;
    }

    private Map<String, Object> getDockerHostConfig(Optional<ContainerInfo> info) {
        return info.map(ContainerInfo::getHostConfig).orElse(Collections.emptyMap());
    }

    private DockerAssetsPath getAssetsPath(Optional<ContainerInfo> info) {
        Optional<Map> mountedVolume;
        if (info.isPresent() && (mountedVolume = info.get().getMountedVolumes().stream().filter(mounted -> DEFAULT_ASSETS_PATH.equalsIgnoreCase(String.valueOf(mounted.get("Destination")))).findFirst()).isPresent()) {
            String hostPath = String.valueOf(mountedVolume.get().get("Source"));
            return new DockerAssetsPath(hostPath, DEFAULT_ASSETS_PATH);
        }
        Optional<String> assetsPath = this.config.get(DOCKER_SECTION, "assets-path");
        return assetsPath.map(path -> new DockerAssetsPath((String)path, (String)path)).orElse(null);
    }

    private void loadImages(Docker docker, String ... imageNames) {
        CompletableFuture<Void> cd2 = CompletableFuture.allOf((CompletableFuture[])Arrays.stream(imageNames).map(name -> CompletableFuture.supplyAsync(() -> docker.getImage((String)name))).toArray(CompletableFuture[]::new));
        try {
            cd2.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

