/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.HasPermissions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasPermissions
implements AugmenterProvider<HasPermissions>,
AdditionalHttpCommands {
    public static final String SET_PERMISSION = "setPermission";
    private static final Map<String, CommandInfo> COMMANDS = Map.of("setPermission", new CommandInfo("/session/:sessionId/permissions", HttpMethod.POST));

    @Override
    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    @Override
    public Predicate<Capabilities> isApplicable() {
        return caps -> ChromiumDriver.IS_CHROMIUM_BROWSER.test(caps.getBrowserName());
    }

    @Override
    public Class<HasPermissions> getDescribedInterface() {
        return HasPermissions.class;
    }

    @Override
    public HasPermissions getImplementation(Capabilities capabilities, ExecuteMethod executeMethod) {
        return (name, value) -> {
            Require.nonNull("Permission name", name);
            Require.nonNull("Permission value", value);
            executeMethod.execute(SET_PERMISSION, Map.of("descriptor", Map.of("name", name), "state", value));
        };
    }
}

