/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale.highbd;

import org.jcodec.common.model.PictureHiBD;
import org.jcodec.common.tools.MathUtil;
import org.jcodec.scale.highbd.TransformHiBD;

public class Yuv420jToRgbHiBD
implements TransformHiBD {
    private static final int SCALEBITS = 10;
    private static final int ONE_HALF = 512;
    private static final int FIX_0_71414 = Yuv420jToRgbHiBD.FIX(0.71414);
    private static final int FIX_1_772 = Yuv420jToRgbHiBD.FIX(1.772);
    private static final int _FIX_0_34414 = -Yuv420jToRgbHiBD.FIX(0.34414);
    private static final int FIX_1_402 = Yuv420jToRgbHiBD.FIX(1.402);

    @Override
    public final void transform(PictureHiBD src, PictureHiBD dst) {
        int j;
        int[] y = src.getPlaneData(0);
        int[] u = src.getPlaneData(1);
        int[] v = src.getPlaneData(2);
        int[] data = dst.getPlaneData(0);
        int offLuma = 0;
        int offChroma = 0;
        int stride = dst.getWidth();
        for (int i = 0; i < dst.getHeight() >> 1; ++i) {
            for (int k = 0; k < dst.getWidth() >> 1; ++k) {
                int j2 = k << 1;
                Yuv420jToRgbHiBD.YUVJtoRGB(y[offLuma + j2], u[offChroma], v[offChroma], data, (offLuma + j2) * 3);
                Yuv420jToRgbHiBD.YUVJtoRGB(y[offLuma + j2 + 1], u[offChroma], v[offChroma], data, (offLuma + j2 + 1) * 3);
                Yuv420jToRgbHiBD.YUVJtoRGB(y[offLuma + j2 + stride], u[offChroma], v[offChroma], data, (offLuma + j2 + stride) * 3);
                Yuv420jToRgbHiBD.YUVJtoRGB(y[offLuma + j2 + stride + 1], u[offChroma], v[offChroma], data, (offLuma + j2 + stride + 1) * 3);
                ++offChroma;
            }
            if ((dst.getWidth() & 1) != 0) {
                j = dst.getWidth() - 1;
                Yuv420jToRgbHiBD.YUVJtoRGB(y[offLuma + j], u[offChroma], v[offChroma], data, (offLuma + j) * 3);
                Yuv420jToRgbHiBD.YUVJtoRGB(y[offLuma + j + stride], u[offChroma], v[offChroma], data, (offLuma + j + stride) * 3);
                ++offChroma;
            }
            offLuma += 2 * stride;
        }
        if ((dst.getHeight() & 1) != 0) {
            for (int k = 0; k < dst.getWidth() >> 1; ++k) {
                j = k << 1;
                Yuv420jToRgbHiBD.YUVJtoRGB(y[offLuma + j], u[offChroma], v[offChroma], data, (offLuma + j) * 3);
                Yuv420jToRgbHiBD.YUVJtoRGB(y[offLuma + j + 1], u[offChroma], v[offChroma], data, (offLuma + j + 1) * 3);
                ++offChroma;
            }
            if ((dst.getWidth() & 1) != 0) {
                int j3 = dst.getWidth() - 1;
                Yuv420jToRgbHiBD.YUVJtoRGB(y[offLuma + j3], u[offChroma], v[offChroma], data, (offLuma + j3) * 3);
                ++offChroma;
            }
        }
    }

    private static final int FIX(double x) {
        return (int)(x * 1024.0 + 0.5);
    }

    public static final void YUVJtoRGB(int y, int cb, int cr, int[] data, int off) {
        int add_r = FIX_1_402 * (cr -= 128) + 512;
        int add_g = _FIX_0_34414 * (cb -= 128) - FIX_0_71414 * cr + 512;
        int add_b = FIX_1_772 * cb + 512;
        int r = (y <<= 10) + add_r >> 10;
        int g2 = y + add_g >> 10;
        int b = y + add_b >> 10;
        data[off] = MathUtil.clip(r, 0, 255);
        data[off + 1] = MathUtil.clip(g2, 0, 255);
        data[off + 2] = MathUtil.clip(b, 0, 255);
    }
}

