/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.Header;

public class GamaExtension
extends Box {
    private float gamma;

    public static GamaExtension createGamaExtension(float gamma) {
        GamaExtension gamaExtension = new GamaExtension(new Header(GamaExtension.fourcc()));
        gamaExtension.gamma = gamma;
        return gamaExtension;
    }

    public GamaExtension(Header header) {
        super(header);
    }

    @Override
    public void parse(ByteBuffer input) {
        float g2 = input.getInt();
        this.gamma = g2 / 65536.0f;
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.putInt((int)(this.gamma * 65536.0f));
    }

    public float getGamma() {
        return this.gamma;
    }

    public static String fourcc() {
        return "gama";
    }

    @Override
    public int estimateSize() {
        return 12;
    }
}

