/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOIntConsumer;
import org.apache.commons.io.function.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOIntConsumerTest {
    @Test
    void testAccept() throws IOException {
        Assertions.assertDoesNotThrow(() -> IOIntConsumer.NOOP.accept(0));
        Assertions.assertDoesNotThrow(() -> IOIntConsumer.NOOP.accept(46));
        AtomicReference ref = new AtomicReference();
        IOIntConsumer consumer = s2 -> ref.set(s2 + "-");
        consumer.accept(65);
        Assertions.assertEquals((Object)"65-", ref.get());
    }

    @Test
    void testAndThen() throws IOException {
        AtomicReference ref = new AtomicReference();
        IOIntConsumer consumer1 = s2 -> ref.set(s2 + "-");
        IOIntConsumer consumer2 = s2 -> ref.set((String)ref.get() + "=" + s2);
        consumer1.andThen(consumer2).accept(66);
        Assertions.assertEquals((Object)"66-=66", ref.get());
    }

    @Test
    void testAsConsumer() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Optional.of(65).ifPresent(TestUtils.throwingIOIntConsumer().asConsumer()));
        AtomicReference ref = new AtomicReference();
        IOIntConsumer consumer1 = s2 -> ref.set(s2 + "A");
        Optional.of(2).ifPresent(consumer1.asConsumer());
        Assertions.assertEquals((Object)"2A", ref.get());
    }

    @Test
    void testasIntConsumer() {
        AtomicReference ref = new AtomicReference();
        IOIntConsumer consumer1 = s2 -> ref.set(s2 + "A");
        consumer1.asIntConsumer().accept(2);
        Assertions.assertEquals((Object)"2A", ref.get());
    }

    @Test
    void testNOOP() {
        Assertions.assertDoesNotThrow(() -> IOIntConsumer.NOOP.accept(0));
    }
}

