/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.function.Erase;
import org.apache.commons.io.function.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class EraseTest {
    private final AtomicInteger intRef = new AtomicInteger();
    private final AtomicBoolean boolRef = new AtomicBoolean();

    EraseTest() {
    }

    @Test
    void testAcceptIOBiConsumerOfTUTU() {
        Erase.accept((e, f) -> this.boolRef.set(this.intRef.compareAndSet(0, (int)e)), 1, true);
        Assertions.assertEquals((int)1, (int)this.intRef.get());
        Assertions.assertTrue((boolean)this.boolRef.get());
        Assertions.assertThrows(IOException.class, () -> Erase.accept(TestUtils.throwingIOBiConsumer(), null, 1));
    }

    @Test
    void testAcceptIOConsumerOfTT() {
        Erase.accept(e -> this.intRef.compareAndSet(0, (int)e), 1);
        Assertions.assertEquals((int)1, (int)this.intRef.get());
        Assertions.assertThrows(IOException.class, () -> Erase.accept(TestUtils.throwingIOConsumer(), 1));
    }

    @Test
    void testApplyIOBiFunctionOfQsuperTQsuperUQextendsRTU() {
        Assertions.assertTrue((boolean)Erase.apply((i, b) -> this.boolRef.compareAndSet(false, this.intRef.compareAndSet(0, (int)i)), 1, Boolean.TRUE));
        Assertions.assertThrows(IOException.class, () -> Erase.apply(TestUtils.throwingIOBiFunction(), 1, Boolean.TRUE));
    }

    @Test
    void testApplyIOFunctionOfQsuperTQextendsRT() {
        Assertions.assertTrue((boolean)Erase.apply(e -> this.intRef.compareAndSet(0, (int)e), 1));
        Assertions.assertThrows(IOException.class, () -> Erase.apply(TestUtils.throwingIOFunction(), 1));
    }

    @Test
    void testCompare() {
        Assertions.assertEquals((int)0, (int)Erase.compare(String::compareTo, "A", "A"));
        Assertions.assertEquals((int)-1, (int)Erase.compare(String::compareTo, "A", "B"));
        Assertions.assertEquals((int)1, (int)Erase.compare(String::compareTo, "B", "A"));
        Assertions.assertThrows(IOException.class, () -> Erase.compare(TestUtils.throwingIOComparator(), null, null));
    }

    @Test
    void testGet() {
        Assertions.assertEquals((int)0, (Integer)Erase.get(() -> this.intRef.get()));
        Assertions.assertThrows(IOException.class, () -> Erase.get(TestUtils.throwingIOSupplier()));
    }

    @Test
    void testRethrow() {
        Assertions.assertThrows(IOException.class, () -> Erase.rethrow(new IOException()));
    }

    @Test
    void testRun() {
        Erase.run(() -> this.intRef.set(1));
        Assertions.assertEquals((int)1, (int)this.intRef.get());
        Assertions.assertThrows(IOException.class, () -> Erase.run(TestUtils.throwingIORunnable()));
    }

    @Test
    void testTest() {
        Assertions.assertTrue((boolean)Erase.test(e -> this.intRef.compareAndSet(0, (int)e), 1));
        Assertions.assertThrows(IOException.class, () -> Erase.test(TestUtils.throwingIOPredicate(), 1));
    }
}

