/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IOUtilsMultithreadedSkipTest {
    private static final String FIXTURE = "TIKA-4065.bin";
    long seed = 1L;
    private final ThreadLocal<byte[]> threadLocal = ThreadLocal.withInitial(() -> new byte[4096]);

    private int[] generateExpected(InputStream is, int[] skips) throws IOException {
        int[] testBytes = new int[skips.length];
        for (int i = 0; i < skips.length; ++i) {
            try {
                IOUtils.skipFully(is, (long)skips[i]);
                testBytes[i] = is.read();
                continue;
            }
            catch (EOFException e) {
                testBytes[i] = -1;
            }
        }
        return testBytes;
    }

    private int[] generateSkips(byte[] bytes, int numSkips, Random random) {
        int[] skips = new int[numSkips];
        for (int i = 0; i < skips.length; ++i) {
            skips[i] = random.nextInt(bytes.length / numSkips) + bytes.length / 10;
        }
        return skips;
    }

    private InputStream inflate(byte[] deflated) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)new InflaterInputStream(new ByteArrayInputStream(deflated), new Inflater(true)), (OutputStream)bos);
        return new ByteArrayInputStream(bos.toByteArray());
    }

    @BeforeEach
    public void setUp() {
        this.seed = new Random().nextLong();
    }

    private void testSkipFullyOnInflaterInputStream(Supplier<byte[]> baSupplier) throws Exception {
        int[] expected;
        byte[] bytes;
        long thisSeed = this.seed;
        Random random = new Random(thisSeed);
        try (InputStream inputStream = this.getClass().getResourceAsStream(FIXTURE);){
            bytes = IOUtils.toByteArray(inputStream);
        }
        int numSkips = random.nextInt(bytes.length) / 100 + 1;
        int[] skips = this.generateSkips(bytes, numSkips, random);
        try (InputStream inflate = this.inflate(bytes);){
            expected = this.generateExpected(inflate, skips);
        }
        int numThreads = 2;
        int iterations = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<Integer> executorCompletionService = new ExecutorCompletionService<Integer>(executorService);
        for (int i = 0; i < 2; ++i) {
            executorCompletionService.submit(() -> {
                for (int iteration = 0; iteration < 100; ++iteration) {
                    try (InflaterInputStream is = new InflaterInputStream(new ByteArrayInputStream(bytes), new Inflater(true));){
                        for (int skipIndex = 0; skipIndex < skips.length; ++skipIndex) {
                            try {
                                IOUtils.skipFully(is, skips[skipIndex], baSupplier);
                                int c = ((InputStream)is).read();
                                Assertions.assertEquals((int)expected[skipIndex], (int)c, (String)("failed on seed=" + this.seed + " iteration=" + iteration));
                                continue;
                            }
                            catch (EOFException e) {
                                Assertions.assertEquals((int)expected[skipIndex], (int)((InputStream)is).read(), (String)("failed on seed=" + this.seed + " iteration=" + iteration));
                            }
                        }
                        continue;
                    }
                }
                return 1;
            });
        }
        for (int finished = 0; finished < 2; ++finished) {
            Future future = executorCompletionService.take();
            try {
                future.get();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)("failed on seed=" + this.seed));
            }
        }
    }

    @Test
    public void testSkipFullyOnInflaterInputStream_New_bytes() throws Exception {
        this.testSkipFullyOnInflaterInputStream(() -> new byte[4096]);
    }

    @Test
    public void testSkipFullyOnInflaterInputStream_ThreadLocal() throws Exception {
        this.testSkipFullyOnInflaterInputStream(this.threadLocal::get);
    }
}

