/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.error;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.error.RVLCTables;
import net.sourceforge.jaad.aac.syntax.IBitStream;
import net.sourceforge.jaad.aac.syntax.ICSInfo;
import net.sourceforge.jaad.aac.syntax.ICStream;

public class RVLC
implements RVLCTables {
    private static final int ESCAPE_FLAG = 7;

    public void decode(IBitStream _in, ICStream ics, int[][] scaleFactors) throws AACException {
        int bits = ics.getInfo().isEightShortFrame() ? 11 : 9;
        boolean sfConcealment = _in.readBool();
        int revGlobalGain = _in.readBits(8);
        int rvlcSFLen = _in.readBits(bits);
        ICSInfo info = ics.getInfo();
        int windowGroupCount = info.getWindowGroupCount();
        int maxSFB = info.getMaxSFB();
        int[][] sfbCB = new int[][]{new int[0]};
        int sf = ics.getGlobalGain();
        int intensityPosition = 0;
        int noiseEnergy = sf - 90 - 256;
        boolean intensityUsed = false;
        boolean noiseUsed = false;
        for (int g2 = 0; g2 < windowGroupCount; ++g2) {
            block6: for (int sfb = 0; sfb < maxSFB; ++sfb) {
                switch (sfbCB[g2][sfb]) {
                    case 0: {
                        scaleFactors[g2][sfb] = 0;
                        continue block6;
                    }
                    case 14: 
                    case 15: {
                        if (!intensityUsed) {
                            intensityUsed = true;
                        }
                        scaleFactors[g2][sfb] = intensityPosition += this.decodeHuffman(_in);
                        continue block6;
                    }
                    case 13: {
                        if (noiseUsed) {
                            scaleFactors[g2][sfb] = noiseEnergy += this.decodeHuffman(_in);
                            continue block6;
                        }
                        noiseUsed = true;
                        noiseEnergy = this.decodeHuffman(_in);
                        continue block6;
                    }
                    default: {
                        scaleFactors[g2][sfb] = sf += this.decodeHuffman(_in);
                    }
                }
            }
        }
        int lastIntensityPosition = 0;
        if (intensityUsed) {
            lastIntensityPosition = this.decodeHuffman(_in);
        }
        noiseUsed = false;
        if (_in.readBool()) {
            this.decodeEscapes(_in, ics, scaleFactors);
        }
    }

    private void decodeEscapes(IBitStream _in, ICStream ics, int[][] scaleFactors) throws AACException {
        ICSInfo info = ics.getInfo();
        int windowGroupCount = info.getWindowGroupCount();
        int maxSFB = info.getMaxSFB();
        int[][] sfbCB = new int[][]{new int[0]};
        int escapesLen = _in.readBits(8);
        boolean noiseUsed = false;
        for (int g2 = 0; g2 < windowGroupCount; ++g2) {
            for (int sfb = 0; sfb < maxSFB; ++sfb) {
                if (sfbCB[g2][sfb] == 13 && !noiseUsed) {
                    noiseUsed = true;
                    continue;
                }
                if (Math.abs(sfbCB[g2][sfb]) != 7) continue;
                int val = this.decodeHuffmanEscape(_in);
                if (sfbCB[g2][sfb] == -7) {
                    int[] nArray = scaleFactors[g2];
                    int n = sfb;
                    nArray[n] = nArray[n] - val;
                    continue;
                }
                int[] nArray = scaleFactors[g2];
                int n = sfb;
                nArray[n] = nArray[n] + val;
            }
        }
    }

    private int decodeHuffman(IBitStream _in) throws AACException {
        int j;
        int off = 0;
        int i = RVLC_BOOK[off][1];
        for (int cw = _in.readBits(i); cw != RVLC_BOOK[off][2] && i < 10; cw |= _in.readBits(j)) {
            j = RVLC_BOOK[++off][1] - i;
            i += j;
            cw <<= j;
        }
        return RVLC_BOOK[off][0];
    }

    private int decodeHuffmanEscape(IBitStream _in) throws AACException {
        int j;
        int off = 0;
        int i = ESCAPE_BOOK[off][1];
        for (int cw = _in.readBits(i); cw != ESCAPE_BOOK[off][2] && i < 21; cw |= _in.readBits(j)) {
            j = ESCAPE_BOOK[++off][1] - i;
            i += j;
            cw <<= j;
        }
        return ESCAPE_BOOK[off][0];
    }
}

