/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.error;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.error.BitsBuffer;
import net.sourceforge.jaad.aac.syntax.IBitStream;
import net.sourceforge.jaad.aac.syntax.ICSInfo;
import net.sourceforge.jaad.aac.syntax.ICStream;
import net.sourceforge.jaad.aac.syntax.SyntaxConstants;

public class HCR
implements SyntaxConstants {
    private static final int NUM_CB = 6;
    private static final int NUM_CB_ER = 22;
    private static final int MAX_CB = 32;
    private static final int VCB11_FIRST = 16;
    private static final int VCB11_LAST = 31;
    private static final int[] PRE_SORT_CB_STD = new int[]{11, 9, 7, 5, 3, 1};
    private static final int[] PRE_SORT_CB_ER = new int[]{11, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 9, 7, 5, 3, 1};
    private static final int[] MAX_CW_LEN = new int[]{0, 11, 9, 20, 16, 13, 11, 14, 12, 17, 14, 49, 0, 0, 0, 0, 14, 17, 21, 21, 25, 25, 29, 29, 29, 29, 33, 33, 33, 37, 37, 41};

    private static boolean isGoodCB(int cb, int sectCB) {
        boolean b = false;
        if (sectCB > 0 && sectCB <= 11 || sectCB >= 16 && sectCB <= 31) {
            b = cb < 11 ? sectCB == cb || sectCB == cb + 1 : sectCB == cb;
        }
        return b;
    }

    public static void decodeReorderedSpectralData(ICStream ics, IBitStream _in, short[] spectralData, boolean sectionDataResilience) throws AACException {
        int i;
        int lastCB;
        int[] preSortCB;
        int g2;
        ICSInfo info = ics.getInfo();
        int windowGroupCount = info.getWindowGroupCount();
        int maxSFB = info.getMaxSFB();
        int[] swbOffsets = info.getSWBOffsets();
        int swbOffsetMax = info.getSWBOffsetMax();
        int[][] sectStart = new int[0][0];
        int[][] sectEnd = new int[0][0];
        int[] numSec = new int[]{};
        int[][] sectCB = new int[0][0];
        int[][] sectSFBOffsets = new int[0][0];
        int spDataLen = ics.getReorderedSpectralDataLength();
        if (spDataLen == 0) {
            return;
        }
        int longestLen = ics.getLongestCodewordLength();
        if (longestLen == 0 || longestLen >= spDataLen) {
            throw new AACException("length of longest HCR codeword out of range");
        }
        int[] spOffsets = new int[8];
        int shortFrameLen = spectralData.length / 8;
        spOffsets[0] = 0;
        for (g2 = 1; g2 < windowGroupCount; ++g2) {
            spOffsets[g2] = spOffsets[g2 - 1] + shortFrameLen * info.getWindowGroupLength(g2 - 1);
        }
        Codeword[] codeword = new Codeword[512];
        BitsBuffer[] segment = new BitsBuffer[512];
        if (sectionDataResilience) {
            preSortCB = PRE_SORT_CB_ER;
            lastCB = 22;
        } else {
            preSortCB = PRE_SORT_CB_STD;
            lastCB = 6;
        }
        boolean PCWs_done = false;
        int segmentsCount = 0;
        int numberOfCodewords = 0;
        int bitsread = 0;
        for (int sortloop = 0; sortloop < lastCB; ++sortloop) {
            int thisCB = preSortCB[sortloop];
            for (int sfb = 0; sfb < maxSFB; ++sfb) {
                int w_idx = 0;
                while (4 * w_idx < Math.min(swbOffsets[sfb + 1], swbOffsetMax) - swbOffsets[sfb]) {
                    for (g2 = 0; g2 < windowGroupCount; ++g2) {
                        for (i = 0; i < numSec[g2]; ++i) {
                            int thisSectCB;
                            if (sectStart[g2][i] > sfb || sectEnd[g2][i] <= sfb || !HCR.isGoodCB(thisCB, thisSectCB = sectCB[g2][i])) continue;
                            int sect_sfb_size = sectSFBOffsets[g2][sfb + 1] - sectSFBOffsets[g2][sfb];
                            int inc = thisSectCB < 5 ? 4 : 2;
                            int group_cws_count = 4 * info.getWindowGroupLength(g2) / inc;
                            int segwidth = Math.min(MAX_CW_LEN[thisSectCB], longestLen);
                            for (int cws = 0; cws < group_cws_count && cws + w_idx * group_cws_count < sect_sfb_size; ++cws) {
                                int sp = spOffsets[g2] + sectSFBOffsets[g2][sfb] + inc * (cws + w_idx * group_cws_count);
                                if (!PCWs_done) {
                                    if (bitsread + segwidth <= spDataLen) {
                                        segment[segmentsCount].readSegment(segwidth, _in);
                                        bitsread += segwidth;
                                        segment[segmentsCount].rewindReverse();
                                        ++segmentsCount;
                                    } else {
                                        if (bitsread < spDataLen) {
                                            int additional_bits = spDataLen - bitsread;
                                            segment[segmentsCount].readSegment(additional_bits, _in);
                                            segment[segmentsCount].len += segment[segmentsCount - 1].len;
                                            segment[segmentsCount].rewindReverse();
                                            if (segment[segmentsCount - 1].len > 32) {
                                                segment[segmentsCount - 1].bufb = segment[segmentsCount].bufb + segment[segmentsCount - 1].showBits(segment[segmentsCount - 1].len - 32);
                                                segment[segmentsCount - 1].bufa = segment[segmentsCount].bufa + segment[segmentsCount - 1].showBits(32);
                                            } else {
                                                segment[segmentsCount - 1].bufa = segment[segmentsCount].bufa + segment[segmentsCount - 1].showBits(segment[segmentsCount - 1].len);
                                                segment[segmentsCount - 1].bufb = segment[segmentsCount].bufb;
                                            }
                                            segment[segmentsCount - 1].len += additional_bits;
                                        }
                                        bitsread = spDataLen;
                                        PCWs_done = true;
                                        codeword[0].fill(sp, thisSectCB);
                                    }
                                } else {
                                    codeword[numberOfCodewords - segmentsCount].fill(sp, thisSectCB);
                                }
                                ++numberOfCodewords;
                            }
                        }
                    }
                    ++w_idx;
                }
            }
        }
        if (segmentsCount == 0) {
            throw new AACException("no segments _in HCR");
        }
        int numberOfSets = numberOfCodewords / segmentsCount;
        for (int set = 1; set <= numberOfSets; ++set) {
            block8: for (int trial = 0; trial < segmentsCount; ++trial) {
                for (int codewordBase = 0; codewordBase < segmentsCount; ++codewordBase) {
                    int segmentID = (trial + codewordBase) % segmentsCount;
                    int codewordID = codewordBase + set * segmentsCount - segmentsCount;
                    if (codewordID >= numberOfCodewords - segmentsCount) continue block8;
                    if (codeword[codewordID].decoded != 0 || segment[segmentID].len <= 0) continue;
                    if (codeword[codewordID].bits.len != 0) {
                        segment[segmentID].concatBits(codeword[codewordID].bits);
                    }
                    int n = segment[segmentID].len;
                }
            }
            for (i = 0; i < segmentsCount; ++i) {
                segment[i].rewindReverse();
            }
        }
    }

    private static class Codeword {
        int cb;
        int decoded;
        int sp_offset;
        BitsBuffer bits;

        private Codeword() {
        }

        private void fill(int sp, int cb) {
            this.sp_offset = sp;
            this.cb = cb;
            this.decoded = 0;
            this.bits = new BitsBuffer();
        }
    }
}

