/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.Internal;
import graphql.language.AbstractNode;
import graphql.language.AstPrinter;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;

@Internal
public class TypeInfo {
    private final Type rawType;
    private final TypeName typeName;
    private final Deque<Class<?>> decoration = new ArrayDeque();

    public static TypeInfo typeInfo(Type type) {
        return new TypeInfo(type);
    }

    private TypeInfo(Type type) {
        this.rawType = Assert.assertNotNull(type, () -> "type must not be null");
        while (!(type instanceof TypeName)) {
            if (type instanceof NonNullType) {
                this.decoration.push(NonNullType.class);
                type = ((NonNullType)type).getType();
            }
            if (!(type instanceof ListType)) continue;
            this.decoration.push(ListType.class);
            type = ((ListType)type).getType();
        }
        this.typeName = (TypeName)type;
    }

    public Type getRawType() {
        return this.rawType;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public String getName() {
        return this.typeName.getName();
    }

    public boolean isList() {
        return this.rawType instanceof ListType;
    }

    public boolean isNonNull() {
        return this.rawType instanceof NonNullType;
    }

    public boolean isPlain() {
        return !this.isList() && !this.isNonNull();
    }

    public TypeInfo renameAs(String newName) {
        AbstractNode out = TypeName.newTypeName(newName).build();
        ArrayDeque wrappingStack = new ArrayDeque(this.decoration);
        while (!wrappingStack.isEmpty()) {
            Class clazz = (Class)wrappingStack.pop();
            if (clazz.equals(NonNullType.class)) {
                out = NonNullType.newNonNullType(out).build();
            }
            if (!clazz.equals(ListType.class)) continue;
            out = ListType.newListType(out).build();
        }
        return TypeInfo.typeInfo(out);
    }

    public <T extends GraphQLType> T decorate(GraphQLType objectType) {
        GraphQLType out = objectType;
        ArrayDeque wrappingStack = new ArrayDeque(this.decoration);
        while (!wrappingStack.isEmpty()) {
            Class clazz = (Class)wrappingStack.pop();
            if (clazz.equals(NonNullType.class)) {
                out = GraphQLNonNull.nonNull(out);
            }
            if (!clazz.equals(ListType.class)) continue;
            out = GraphQLList.list(out);
        }
        return (T)out;
    }

    public static String getAstDesc(Type type) {
        return AstPrinter.printAst(type);
    }

    public TypeInfo unwrapOne() {
        if (this.rawType instanceof NonNullType) {
            return TypeInfo.typeInfo(((NonNullType)this.rawType).getType());
        }
        if (this.rawType instanceof ListType) {
            return TypeInfo.typeInfo(((ListType)this.rawType).getType());
        }
        return this;
    }

    public Type unwrapOneType() {
        return this.unwrapOne().getRawType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeInfo typeInfo = (TypeInfo)o;
        return this.isNonNull() == typeInfo.isNonNull() && this.isList() == typeInfo.isList() && Objects.equals(this.typeName.getName(), typeInfo.typeName.getName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.typeName.getName());
        result = 31 * result + Boolean.hashCode(this.isNonNull());
        result = 31 * result + Boolean.hashCode(this.isList());
        return result;
    }

    public String toString() {
        return "TypeInfo{" + TypeInfo.getAstDesc(this.rawType) + "}";
    }
}

