/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Internal;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResultPath;

@Internal
public class NonNullableFieldValidator {
    private final ExecutionContext executionContext;
    private final ExecutionStepInfo executionStepInfo;

    public NonNullableFieldValidator(ExecutionContext executionContext, ExecutionStepInfo executionStepInfo) {
        this.executionContext = executionContext;
        this.executionStepInfo = executionStepInfo;
    }

    public <T> T validate(ExecutionStrategyParameters parameters, T result) throws NonNullableFieldWasNullException {
        if (result == null && this.executionStepInfo.isNonNullType()) {
            ResultPath path = parameters.getPath();
            NonNullableFieldWasNullException nonNullException = new NonNullableFieldWasNullException(this.executionStepInfo, path);
            NonNullableFieldWasNullError error = new NonNullableFieldWasNullError(nonNullException);
            if (parameters.getDeferredCallContext() != null) {
                parameters.getDeferredCallContext().addError(error);
            } else {
                this.executionContext.addError(error, path);
            }
            throw nonNullException;
        }
        return result;
    }
}

