/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.execution.MergedField;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public class MergedSelectionSet {
    private final Map<String, MergedField> subFields;
    private final List<String> keys;

    protected MergedSelectionSet(Map<String, MergedField> subFields) {
        this.subFields = subFields == null ? ImmutableMap.of() : subFields;
        this.keys = ImmutableList.copyOf(this.subFields.keySet());
    }

    public Map<String, MergedField> getSubFields() {
        return this.subFields;
    }

    public List<MergedField> getSubFieldsList() {
        return ImmutableList.copyOf(this.subFields.values());
    }

    public int size() {
        return this.subFields.size();
    }

    public Set<String> keySet() {
        return this.subFields.keySet();
    }

    public MergedField getSubField(String key) {
        return this.subFields.get(key);
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public boolean isEmpty() {
        return this.subFields.isEmpty();
    }

    public static Builder newMergedSelectionSet() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, MergedField> subFields;

        private Builder() {
        }

        public Builder subFields(Map<String, MergedField> subFields) {
            this.subFields = subFields;
            return this;
        }

        public MergedSelectionSet build() {
            return new MergedSelectionSet(this.subFields);
        }
    }
}

