/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.concurrent;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public class Lazy<T> {
    private volatile @Nullable T value;
    private final Supplier<T> supplier;

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public Optional<T> getIfInitialized() {
        return Optional.ofNullable(this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (this.value == null) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (this.value == null) {
                    this.value = this.supplier.get();
                }
            }
        }
        return Objects.requireNonNull(this.value);
    }

    public static <T> Lazy<T> lazy(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }
}

