/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.output.BrokenOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ThresholdingOutputStreamTest {
    ThresholdingOutputStreamTest() {
    }

    static void assertThresholdingInitialState(ThresholdingOutputStream out, int expectedThreshold, int expectedByeCount) {
        Assertions.assertFalse((boolean)out.isThresholdExceeded());
        Assertions.assertEquals((int)expectedThreshold, (int)out.getThreshold());
        Assertions.assertEquals((long)expectedByeCount, (long)out.getByteCount());
    }

    @Test
    void testResetByteCount() throws IOException {
        boolean threshold = true;
        AtomicInteger counter = new AtomicInteger();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             ThresholdingOutputStream out = new ThresholdingOutputStream(1, tos -> {
            counter.incrementAndGet();
            tos.resetByteCount();
        }, o -> os);){
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 1, 0);
            Assertions.assertEquals((int)0, (int)counter.get());
            out.write(97);
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            out.write(97);
            Assertions.assertEquals((int)1, (int)counter.get());
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            out.write(97);
            out.write(97);
            Assertions.assertEquals((int)3, (int)counter.get());
        }
    }

    @Test
    void testResetByteCountBrokenOutputStream() throws IOException {
        boolean threshold = true;
        AtomicInteger counter = new AtomicInteger();
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();
                 ThresholdingOutputStream out = new ThresholdingOutputStream(1, tos -> {
                counter.incrementAndGet();
                tos.resetByteCount();
            }, o -> BrokenOutputStream.INSTANCE);){
                ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 1, 0);
                Assertions.assertEquals((int)0, (int)counter.get());
                Assertions.assertThrows(IOException.class, () -> out.write(97));
                Assertions.assertFalse((boolean)out.isThresholdExceeded());
                Assertions.assertThrows(IOException.class, () -> out.write(97));
                Assertions.assertEquals((int)0, (int)counter.get());
                Assertions.assertFalse((boolean)out.isThresholdExceeded());
                Assertions.assertThrows(IOException.class, () -> out.write(97));
                Assertions.assertThrows(IOException.class, () -> out.write(97));
                Assertions.assertEquals((int)0, (int)counter.get());
            }
        });
        Assertions.assertEquals((Object)"Broken output stream: close()", (Object)e.getMessage());
    }

    @Test
    void testSetByteCountOutputStream() throws IOException {
        final AtomicBoolean reached = new AtomicBoolean();
        int initCount = 2;
        int threshold = 3;
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(3){
            {
                super(arg0);
                this.setByteCount(2L);
            }

            protected OutputStream getOutputStream() throws IOException {
                return new ByteArrayOutputStream(4);
            }

            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 3, 2);
            out.write(97);
            Assertions.assertFalse((boolean)reached.get());
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            out.write(97);
            Assertions.assertTrue((boolean)reached.get());
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
        }
    }

    @Test
    void testSetByteCountStream() throws IOException {
        final AtomicBoolean reached = new AtomicBoolean();
        int initCount = 2;
        int threshold = 3;
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(3){
            {
                super(arg0);
                this.setByteCount(2L);
            }

            protected OutputStream getStream() throws IOException {
                return new ByteArrayOutputStream(4);
            }

            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 3, 2);
            out.write(97);
            Assertions.assertFalse((boolean)reached.get());
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            out.write(97);
            Assertions.assertTrue((boolean)reached.get());
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
        }
    }

    @Test
    void testThresholdIOConsumer() throws IOException {
        boolean threshold = true;
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(1, null, os -> new ByteArrayOutputStream(4));){
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 1, 0);
            out.write(97);
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            out.write(97);
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
        }
        AtomicBoolean reached = new AtomicBoolean();
        reached.set(false);
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(1, os -> reached.set(true), null);){
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 1, 0);
            out.write(97);
            Assertions.assertFalse((boolean)reached.get());
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            out.write(97);
            Assertions.assertTrue((boolean)reached.get());
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
        }
        reached.set(false);
        out = new ThresholdingOutputStream(1, os -> reached.set(true), os -> new ByteArrayOutputStream(4));
        try {
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 1, 0);
            out.write(97);
            Assertions.assertFalse((boolean)reached.get());
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            out.write(97);
            Assertions.assertTrue((boolean)reached.get());
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
        }
        finally {
            out.close();
        }
    }

    @Test
    void testThresholdIOConsumerIOException() throws IOException {
        boolean threshold = true;
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(1, os -> {
            throw new IOException("Threshold reached.");
        }, os -> new ByteArrayOutputStream(4));){
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 1, 0);
            out.write(97);
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            Assertions.assertThrows(IOException.class, () -> out.write(97));
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
        }
    }

    @Test
    void testThresholdIOConsumerUncheckedException() throws IOException {
        boolean threshold = true;
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(1, os -> {
            throw new IllegalStateException("Threshold reached.");
        }, os -> new ByteArrayOutputStream(4));){
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 1, 0);
            out.write(97);
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            Assertions.assertThrows(IllegalStateException.class, () -> out.write(97));
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            Assertions.assertInstanceOf(ByteArrayOutputStream.class, (Object)out.getOutputStream());
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
        }
    }

    @Test
    void testThresholdLessThanZero() throws IOException {
        final AtomicBoolean reached = new AtomicBoolean();
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(-1){

            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 0, 0);
            Assertions.assertFalse((boolean)reached.get());
            out.write(89);
            Assertions.assertTrue((boolean)reached.get());
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
            Assertions.assertInstanceOf(NullOutputStream.class, (Object)out.getOutputStream());
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
        }
    }

    @Test
    void testThresholdZero() throws IOException {
        final AtomicBoolean reached = new AtomicBoolean();
        boolean threshold = false;
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(0){

            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 0, 0);
            out.write(89);
            Assertions.assertTrue((boolean)reached.get());
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
            Assertions.assertInstanceOf(NullOutputStream.class, (Object)out.getOutputStream());
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
        }
    }

    @Test
    void testThresholdZeroWrite() throws IOException {
        final AtomicBoolean reached = new AtomicBoolean();
        int threshold = 7;
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(7){

            protected void thresholdReached() throws IOException {
                super.thresholdReached();
                reached.set(true);
            }
        };){
            ThresholdingOutputStreamTest.assertThresholdingInitialState(out, 7, 0);
            Assertions.assertFalse((boolean)reached.get());
            out.write(new byte[0]);
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            Assertions.assertFalse((boolean)reached.get());
            Assertions.assertInstanceOf(NullOutputStream.class, (Object)out.getOutputStream());
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
        }
    }
}

