/*
 * Decompiled with CFR 0.152.
 */
package rainbowPackage;

import java.awt.Dimension;
import javafx.scene.paint.Color;
import rainbowPackage.ColorArrayReverser;
import rainbowPackage.RainbowSoftColor;
import rainbowPackage.TrueArcTan;
import rainbowPackage.VibrantColors;

public final class RainbowPattern2D {
    public double[] rgb = new double[]{0.0, 0.0, 0.0};
    public double[] argb = new double[]{0.0, 0.0, 0.0, 1.0};
    public Color fxColor;
    public double colorBeingChecked = 0.0;
    public double opacityBeingChecked = 1.0;
    public double sliderValue = 0.0;
    public double originalFormulaValue = 0.0;
    public double numberOfTransitions = 0.0;
    public RainbowSoftColor color = new RainbowSoftColor(new double[]{0.0, 0.0, 0.0, 1.0});
    public ColorArrayReverser colorArrayReverser = new ColorArrayReverser();

    public RainbowPattern2D(Color FXColor) {
        this.fxColor = FXColor;
        this.color = new RainbowSoftColor(FXColor);
        this.rgb = new double[]{FXColor.getRed() * 255.0, FXColor.getGreen() * 255.0, FXColor.getBlue() * 255.0};
        this.argb = new double[]{FXColor.getRed() * 255.0, FXColor.getGreen() * 255.0, FXColor.getBlue() * 255.0, FXColor.getOpacity()};
    }

    public RainbowPattern2D(double[] ARGB) {
        int z = 0;
        while (z <= 2) {
            this.rgb[z] = this.ColorValueFitter(ARGB[z]);
            this.argb[z] = this.ColorValueFitter(ARGB[z]);
            ++z;
        }
        if (ARGB.length == 3) {
            this.argb = new double[4];
            z = 0;
            while (z <= 2) {
                this.argb[z] = this.ColorValueFitter(this.rgb[z]);
                ++z;
            }
            ARGB[3] = 1.0;
        } else {
            this.argb[3] = this.OpacityValueFitter(ARGB[3]);
        }
        this.color = new RainbowSoftColor(ARGB);
        this.fxColor = this.color.ToFXColor();
    }

    public RainbowPattern2D() {
        this.rgb = new double[]{0.0, 0.0, 0.0};
        this.argb = new double[]{0.0, 0.0, 0.0, 1.0};
        this.color = new RainbowSoftColor(this.rgb);
        this.fxColor = this.color.ToFXColor();
    }

    public Color ToFXColor() {
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color ToFXColor(double[] ARGB) {
        int z = 0;
        while (z <= 2) {
            this.rgb[z] = this.ColorValueFitter(ARGB[z]);
            this.argb[z] = this.ColorValueFitter(ARGB[z]);
            ++z;
        }
        this.argb[3] = ARGB.length <= 3 ? 1.0 : this.OpacityValueFitter(ARGB[3]);
        this.color = new RainbowSoftColor(this.argb);
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowSoftColorFunction(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, RainbowSoftColor ColorBefore, RainbowSoftColor ColorAfter) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        int z = 0;
        while (z <= 2) {
            this.rgb[z] = this.ColorValueFitter(ColorAfter.rgb[z] + ColorBefore.rgb[z] - ColorBefore.rgb[z] * this.sliderValue / ColorsLength - ColorAfter.rgb[z] * (ColorsLength - this.sliderValue) / ColorsLength);
            this.argb[z] = this.ColorValueFitter(this.rgb[z]);
            ++z;
        }
        this.argb[3] = 1.0;
        this.color = new RainbowSoftColor(this.rgb);
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleRainbow(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        this.color.RainbowSoftColorRainbowFunction(Math.abs(ColorsLength), this.sliderValue);
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleRainbow(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        this.color.RainbowSoftColorRainbowFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations);
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleRainbow(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, boolean Adjusted) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        if (Adjusted) {
            this.color.RainbowSoftColorRainbowFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations);
        } else {
            this.color.RainbowSoftColorRainbowFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleRainbowReverse(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        this.color.RainbowSoftColorRainbowFunctionReverse(Math.abs(ColorsLength), this.sliderValue);
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleRainbowReverse(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        this.color.RainbowSoftColorRainbowFunctionReverseAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations);
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleRainbowReverse(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, boolean Adjusted) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        if (Adjusted) {
            this.color.RainbowSoftColorRainbowFunctionReverseAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations);
        } else {
            this.color.RainbowSoftColorRainbowFunctionReverseUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double[][] RGBcolorArray) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsLength), this.sliderValue, RGBcolorArray);
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, Color[] FXcolorArray) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsLength), this.sliderValue, FXcolorArray);
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, double[][] ARGBcolorArray) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        this.color.RainbowSoftCustomColorFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, ARGBcolorArray);
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, double[][] ARGBcolorArray, boolean Adjusted) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        if (Adjusted) {
            this.color.RainbowSoftCustomColorFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, ARGBcolorArray);
        } else {
            this.color.RainbowSoftCustomColorFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, ARGBcolorArray);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, Color[] FXcolorArray) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        this.color.RainbowSoftCustomColorFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray);
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, Color[] FXcolorArray, boolean Adjusted) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        if (Adjusted) {
            this.color.RainbowSoftCustomColorFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray);
        } else {
            this.color.RainbowSoftCustomColorFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleRainbow(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        this.color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleRainbow(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        if (Adjusted) {
            this.color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleRainbowReverse(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        this.color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleRainbowReverse(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        if (Adjusted) {
            this.color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, double[][] RGBcolorArray, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        if (Adjusted) {
            this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, RGBcolorArray, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, RGBcolorArray, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double BrightnessMultiplyer, int Gradations, Color[] FXcolorArray, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength) : this.SliderFormulateDoubleSliding(ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength));
        if (Adjusted) {
            this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowDiskVaryated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, boolean Reversed) {
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, this.originalFormulaValue, LocationOfColorMovement, RepeatRadius) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, RepeatRadius) : this.SliderFormulateDoubleSliding(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius));
        if (Reversed) {
            this.color.RainbowSoftColorRainbowFunctionReverse(ColorsLength, this.sliderValue);
        } else {
            this.color.RainbowSoftColorRainbowFunction(ColorsLength, this.sliderValue);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowDiskGradated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, this.originalFormulaValue, LocationOfColorMovement, RepeatRadius) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, RepeatRadius) : this.SliderFormulateDoubleSliding(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowDiskVaryated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, Color[] FXcolorArray, boolean Reversed) {
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, this.originalFormulaValue, LocationOfColorMovement, RepeatRadius) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, RepeatRadius) : this.SliderFormulateDoubleSliding(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius));
        if (Reversed) {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsLength), this.sliderValue, this.colorArrayReverser.ReverseArray(FXcolorArray, true));
        } else {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsLength), this.sliderValue, FXcolorArray);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowDiskGradated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, this.originalFormulaValue, LocationOfColorMovement, RepeatRadius) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, RepeatRadius) : this.SliderFormulateDoubleSliding(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowRingVaryated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double InnerCutOffRadius, double OuterCutOffRadius, boolean Reversed) {
        if (Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) < InnerCutOffRadius || Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) > OuterCutOffRadius) {
            this.color.set(VibrantColors.Clear);
            this.rgb = this.color.rgb;
            this.argb = this.color.argb;
            this.fxColor = this.color.ToFXColor();
            return this.fxColor;
        }
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, this.originalFormulaValue, LocationOfColorMovement, RepeatRadius) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, RepeatRadius) : this.SliderFormulateDoubleSliding(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius));
        if (Reversed) {
            this.color.RainbowSoftColorRainbowFunctionReverse(ColorsLength, this.sliderValue);
        } else {
            this.color.RainbowSoftColorRainbowFunction(ColorsLength, this.sliderValue);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowRingGradated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double InnerCutOffRadius, double OuterCutOffRadius, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        if (Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) < InnerCutOffRadius || Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) > OuterCutOffRadius) {
            this.color.set(VibrantColors.Clear);
            this.rgb = this.color.rgb;
            this.argb = this.color.argb;
            this.fxColor = this.color.ToFXColor();
            return this.fxColor;
        }
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, this.originalFormulaValue, LocationOfColorMovement, RepeatRadius) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, RepeatRadius) : this.SliderFormulateDoubleSliding(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowRingVaryated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double InnerCutOffRadius, double OuterCutOffRadius, Color[] FXcolorArray, boolean Reversed) {
        if (Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) < InnerCutOffRadius || Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) > OuterCutOffRadius) {
            this.color.set(VibrantColors.Clear);
            this.rgb = this.color.rgb;
            this.argb = this.color.argb;
            this.fxColor = this.color.ToFXColor();
            return this.fxColor;
        }
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, this.originalFormulaValue, LocationOfColorMovement, RepeatRadius) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, RepeatRadius) : this.SliderFormulateDoubleSliding(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius));
        if (Reversed) {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsLength), this.sliderValue, this.colorArrayReverser.ReverseArray(FXcolorArray, true));
        } else {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsLength), this.sliderValue, FXcolorArray);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowRingGradated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double InnerCutOffRadius, double OuterCutOffRadius, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        if (Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) < InnerCutOffRadius || Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) > OuterCutOffRadius) {
            this.color.set(VibrantColors.Clear);
            this.rgb = this.color.rgb;
            this.argb = this.color.argb;
            this.fxColor = this.color.ToFXColor();
            return this.fxColor;
        }
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsLength, this.originalFormulaValue, LocationOfColorMovement, RepeatRadius) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, RepeatRadius) : this.SliderFormulateDoubleSliding(ColorsLength, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsLength), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowClockVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, boolean Reversed) {
        this.originalFormulaValue = TrueArcTan.ArcTan(x, y) + Math.PI;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Reversed) {
            this.color.RainbowSoftColorRainbowFunctionReverse(Math.abs(ColorsFactor), this.sliderValue);
        } else {
            this.color.RainbowSoftColorRainbowFunction(Math.abs(ColorsFactor), this.sliderValue);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowClockGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = TrueArcTan.ArcTan(x, y) + Math.PI;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowClockVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, Color[] FXcolorArray, boolean Reversed) {
        this.originalFormulaValue = TrueArcTan.ArcTan(x, y) + Math.PI;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Reversed) {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsFactor), this.sliderValue, this.colorArrayReverser.ReverseArray(FXcolorArray, true));
        } else {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsFactor), this.sliderValue, FXcolorArray);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowClockGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = TrueArcTan.ArcTan(x, y) + Math.PI;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowSpiralVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double SpiralFactor, double NumberOfSpirals, double HalfSreenDiagionalLength, boolean Reversed) {
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) * SpiralFactor + (-TrueArcTan.ArcTan(x, y) + Math.PI) * NumberOfSpirals * HalfSreenDiagionalLength;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, -LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, -LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, -LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Reversed) {
            this.color.RainbowSoftColorRainbowFunctionReverse(ColorsFactor, this.sliderValue);
        } else {
            this.color.RainbowSoftColorRainbowFunction(ColorsFactor, this.sliderValue);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowSpiralGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double SpiralFactor, double NumberOfSpirals, double HalfSreenDiagionalLength, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) * SpiralFactor + (-TrueArcTan.ArcTan(x, y) + Math.PI) * NumberOfSpirals * HalfSreenDiagionalLength;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, -LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, -LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, -LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowSpiralVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double SpiralFactor, double NumberOfSpirals, double HalfSreenDiagionalLength, Color[] FXcolorArray, boolean Reversed) {
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) * SpiralFactor + (-TrueArcTan.ArcTan(x, y) + Math.PI) * NumberOfSpirals * HalfSreenDiagionalLength;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, -LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, -LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, -LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Reversed) {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsFactor), this.sliderValue, this.colorArrayReverser.ReverseArray(FXcolorArray, true));
        } else {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsFactor), this.sliderValue, FXcolorArray);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowSpiralGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double SpiralFactor, double NumberOfSpirals, double HalfSreenDiagionalLength, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) * SpiralFactor + (-TrueArcTan.ArcTan(x, y) + Math.PI) * NumberOfSpirals * HalfSreenDiagionalLength;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, -LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, -LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, -LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowCheapFractalVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double DimWidth, boolean Reversed) {
        this.originalFormulaValue = -(y + 246.0 * LocationOfColorMovement) - (x + 24.0 * LocationOfColorMovement - 2.0 * DimWidth) * Math.pow(Math.abs(LocationOfColorMovement), 1.2) / (y + 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Reversed) {
            this.color.RainbowSoftColorRainbowFunctionReverse(ColorsFactor, this.sliderValue);
        } else {
            this.color.RainbowSoftColorRainbowFunction(ColorsFactor, this.sliderValue);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowCheapFractalGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double DimWidth, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = -(y + 246.0 * LocationOfColorMovement) - (x + 24.0 * LocationOfColorMovement - 2.0 * DimWidth) * Math.pow(Math.abs(LocationOfColorMovement), 1.2) / (y + 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowCheapFractalVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double DimWidth, Color[] FXcolorArray, boolean Reversed) {
        this.originalFormulaValue = -(y + 246.0 * LocationOfColorMovement) - (x + 24.0 * LocationOfColorMovement - 2.0 * DimWidth) * Math.pow(Math.abs(LocationOfColorMovement), 1.2) / (y + 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Reversed) {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsFactor), this.sliderValue, this.colorArrayReverser.ReverseArray(FXcolorArray, true));
        } else {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsFactor), this.sliderValue, FXcolorArray);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowCheapFractalGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double DimWidth, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = -(y + 246.0 * LocationOfColorMovement) - (x + 24.0 * LocationOfColorMovement - 2.0 * DimWidth) * Math.pow(Math.abs(LocationOfColorMovement), 1.2) / (y + 0.5);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowStrobeVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, Dimension Dim, Dimension HalfedDim, double HalfSreenDiagionalLength, boolean Reversed) {
        this.originalFormulaValue = Math.atan2(x - (double)HalfedDim.width + 1.0, y - (double)(Dim.height * 4 / 3) + 1.0);
        this.originalFormulaValue = this.originalFormulaValue * Math.tan(this.originalFormulaValue) * HalfSreenDiagionalLength / 4.46783504 + LocationOfColorMovement;
        this.originalFormulaValue *= 10.0;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Reversed) {
            this.color.RainbowSoftColorRainbowFunctionReverse(ColorsFactor, this.sliderValue);
        } else {
            this.color.RainbowSoftColorRainbowFunction(ColorsFactor, this.sliderValue);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowStrobeGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, Dimension Dim, Dimension HalfedDim, double HalfSreenDiagionalLength, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = Math.atan2(x - (double)HalfedDim.width + 1.0, y - (double)(Dim.height * 4 / 3) + 1.0);
        this.originalFormulaValue = this.originalFormulaValue * Math.tan(this.originalFormulaValue) * HalfSreenDiagionalLength / 4.46783504 + LocationOfColorMovement;
        this.originalFormulaValue *= 10.0;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowStrobeVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, Dimension Dim, Dimension HalfedDim, double HalfSreenDiagionalLength, Color[] FXcolorArray, boolean Reversed) {
        this.originalFormulaValue = Math.atan2(x - (double)HalfedDim.width + 1.0, y - (double)(Dim.height * 4 / 3) + 1.0);
        this.originalFormulaValue = this.originalFormulaValue * Math.tan(this.originalFormulaValue) * HalfSreenDiagionalLength / 4.46783504 + LocationOfColorMovement;
        this.originalFormulaValue *= 10.0;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Reversed) {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsFactor), this.sliderValue, this.colorArrayReverser.ReverseArray(FXcolorArray, true));
        } else {
            this.color.RainbowSoftCustomColorFunction(Math.abs(ColorsFactor), this.sliderValue, FXcolorArray);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowStrobeGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, Dimension Dim, Dimension HalfedDim, double HalfSreenDiagionalLength, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = Math.atan2(x - (double)HalfedDim.width + 1.0, y - (double)(Dim.height * 4 / 3) + 1.0);
        this.originalFormulaValue = this.originalFormulaValue * Math.tan(this.originalFormulaValue) * HalfSreenDiagionalLength / 4.46783504 + LocationOfColorMovement;
        this.originalFormulaValue *= 10.0;
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowExponentiator(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, Dimension Dim, double ExponentValue, double colorFlipper, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = colorFlipper * ColorsFactor * ((Math.pow(1.0 + x / (double)Dim.width, ExponentValue) - 1.0) / (Math.pow(2.0, ExponentValue) - 1.0) + y / (double)Dim.height);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowExponentiator(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, Dimension Dim, double ExponentValue, double colorFlipper, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = colorFlipper * ColorsFactor * ((Math.pow(1.0 + x / (double)Dim.width, ExponentValue) - 1.0) / (Math.pow(2.0, ExponentValue) - 1.0) + y / (double)Dim.height);
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowDoubleExponentiator(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, Dimension Dim, double ExponentValue, double colorFlipper, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = colorFlipper * ColorsFactor * ((Math.pow(1.0 + x / (double)Dim.width, ExponentValue) - 1.0) / (Math.pow(2.0, ExponentValue) - 1.0) + this.Exponentiator(ExponentValue, y * (double)Dim.height / (double)Dim.width, Dim.height * Dim.height / Dim.width));
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public Color RainbowDoubleExponentiator(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, Dimension Dim, double ExponentValue, double colorFlipper, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted) {
        this.originalFormulaValue = colorFlipper * ColorsFactor * ((Math.pow(1.0 + x / (double)Dim.width, ExponentValue) - 1.0) / (Math.pow(2.0, ExponentValue) - 1.0) + this.Exponentiator(ExponentValue, y * (double)Dim.height / (double)Dim.width, Dim.height * Dim.height / Dim.width));
        this.sliderValue = LocationOfStillMovement == 0.0 ? this.SliderFormulateJustMovingColors(ColorsFactor, this.originalFormulaValue, LocationOfColorMovement, RepeatFactor) : (LocationOfColorMovement == 0.0 ? this.SliderFormulateSlidingTransitionsSameColors(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, RepeatFactor) : this.SliderFormulateDoubleSliding(ColorsFactor, this.originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor));
        if (Adjusted) {
            if (Reversed) {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
            } else {
                this.color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
            }
        } else if (Reversed) {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, this.colorArrayReverser.ReverseArray(FXcolorArray, true), OpacityBefore, OpacityAfter);
        } else {
            this.color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs(ColorsFactor), this.sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
        }
        this.rgb = this.color.rgb;
        this.argb = this.color.argb;
        this.fxColor = this.color.ToFXColor();
        return this.fxColor;
    }

    public double Exponentiator(double ExponentValue, double SliderValue, double SliderRange) {
        return (Math.pow(1.0 + SliderValue / SliderRange, ExponentValue) - 1.0) / (Math.pow(2.0, ExponentValue) - 1.0);
    }

    public double Exponentiator(double ExponentValue, double SliderValue, double SliderStart, double SliderFinish) {
        return (Math.pow(1.0 + SliderValue / (SliderFinish - SliderStart), ExponentValue) - 1.0) / (Math.pow(2.0, ExponentValue) - 1.0);
    }

    public double SliderFormulateJustMovingColors(double ColorsLength, double FormulaValue, double LocationOfColorMovement, double RepeatLength) {
        boolean negativeColorsLength = false;
        boolean negativeRepeatLength = false;
        if (ColorsLength < 0.0) {
            negativeColorsLength = true;
            ColorsLength = Math.abs(ColorsLength);
        }
        if (RepeatLength < 0.0) {
            negativeRepeatLength = true;
            RepeatLength = Math.abs(RepeatLength);
        }
        if (RepeatLength == ColorsLength) {
            if (negativeRepeatLength && negativeColorsLength) {
                FormulaValue += LocationOfColorMovement;
                while (RepeatLength - FormulaValue <= 0.0) {
                    FormulaValue -= RepeatLength;
                }
                while (RepeatLength - FormulaValue >= RepeatLength) {
                    FormulaValue += RepeatLength;
                }
                if (FormulaValue - RepeatLength <= -RepeatLength / 2.0) {
                    FormulaValue += 2.0 * RepeatLength;
                }
                return FormulaValue - RepeatLength;
            }
            if (negativeColorsLength) {
                FormulaValue += LocationOfColorMovement;
                while (RepeatLength - FormulaValue <= 0.0) {
                    FormulaValue -= RepeatLength;
                }
                while (RepeatLength - FormulaValue >= RepeatLength) {
                    FormulaValue += RepeatLength;
                }
                return RepeatLength - FormulaValue;
            }
            if (negativeRepeatLength) {
                FormulaValue += LocationOfColorMovement;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                if (FormulaValue >= RepeatLength / 2.0) {
                    return (FormulaValue += 3.0 * RepeatLength / 2.0) - RepeatLength;
                }
                return -FormulaValue;
            }
            FormulaValue += LocationOfColorMovement;
            while (FormulaValue <= 0.0) {
                FormulaValue += RepeatLength;
            }
            while (FormulaValue >= RepeatLength) {
                FormulaValue -= RepeatLength;
            }
        } else if (RepeatLength < ColorsLength) {
            if (negativeRepeatLength && negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfColorMovement = -LocationOfColorMovement * RepeatLength / ColorsLength;
                while (LocationOfColorMovement <= 0.0) {
                    LocationOfColorMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfColorMovement >= RepeatLength) {
                    LocationOfColorMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = FormulaValue - LocationOfColorMovement + this.numberOfTransitions * RepeatLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
                FormulaValue = ColorsLength - FormulaValue;
                while (ColorsLength - FormulaValue <= 0.0) {
                    FormulaValue -= ColorsLength;
                }
                while (ColorsLength - FormulaValue >= ColorsLength) {
                    FormulaValue += ColorsLength;
                }
                if (FormulaValue - ColorsLength <= -ColorsLength / 2.0) {
                    FormulaValue += 2.0 * ColorsLength;
                }
                return FormulaValue - ColorsLength;
            }
            if (negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfColorMovement = -LocationOfColorMovement * RepeatLength / ColorsLength;
                while (LocationOfColorMovement <= 0.0) {
                    LocationOfColorMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfColorMovement >= RepeatLength) {
                    LocationOfColorMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = FormulaValue - LocationOfColorMovement + this.numberOfTransitions * RepeatLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
            } else {
                if (negativeRepeatLength) {
                    this.numberOfTransitions = 0.0;
                    FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= RepeatLength) {
                        FormulaValue -= RepeatLength;
                    }
                    LocationOfColorMovement = -LocationOfColorMovement * RepeatLength / ColorsLength;
                    while (LocationOfColorMovement <= 0.0) {
                        LocationOfColorMovement += RepeatLength;
                        this.numberOfTransitions += 1.0;
                    }
                    while (LocationOfColorMovement >= RepeatLength) {
                        LocationOfColorMovement -= RepeatLength;
                        this.numberOfTransitions -= 1.0;
                    }
                    FormulaValue = FormulaValue - LocationOfColorMovement + this.numberOfTransitions * RepeatLength;
                    FormulaValue -= ColorsLength / 2.0;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += ColorsLength;
                    }
                    while (FormulaValue >= ColorsLength) {
                        FormulaValue -= ColorsLength;
                    }
                    if (FormulaValue >= ColorsLength / 2.0) {
                        return FormulaValue + ColorsLength / 2.0;
                    }
                    return -FormulaValue - ColorsLength / 2.0;
                }
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfColorMovement = -LocationOfColorMovement * RepeatLength / ColorsLength;
                while (LocationOfColorMovement <= 0.0) {
                    LocationOfColorMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfColorMovement >= RepeatLength) {
                    LocationOfColorMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = FormulaValue - LocationOfColorMovement + this.numberOfTransitions * RepeatLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
            }
        } else {
            if (negativeRepeatLength && negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfColorMovement = -LocationOfColorMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (LocationOfColorMovement <= 0.0) {
                    LocationOfColorMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfColorMovement >= (RepeatLength + ColorsLength) / 2.0) {
                    LocationOfColorMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = FormulaValue - LocationOfColorMovement + this.numberOfTransitions * RepeatLength + (RepeatLength + ColorsLength) / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                FormulaValue = RepeatLength - FormulaValue;
                while (RepeatLength - FormulaValue <= 0.0) {
                    FormulaValue -= RepeatLength;
                }
                while (RepeatLength - FormulaValue >= RepeatLength) {
                    FormulaValue += RepeatLength;
                }
                if (FormulaValue - RepeatLength <= -RepeatLength / 2.0) {
                    FormulaValue += 2.0 * RepeatLength;
                }
                return FormulaValue - RepeatLength;
            }
            if (negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfColorMovement = -LocationOfColorMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (LocationOfColorMovement <= 0.0) {
                    LocationOfColorMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfColorMovement >= (RepeatLength + ColorsLength) / 2.0) {
                    LocationOfColorMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = FormulaValue - LocationOfColorMovement + this.numberOfTransitions * RepeatLength + (RepeatLength + ColorsLength) / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
            } else {
                if (negativeRepeatLength) {
                    this.numberOfTransitions = 0.0;
                    FormulaValue = FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                        FormulaValue -= RepeatLength;
                    }
                    LocationOfColorMovement = -LocationOfColorMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                    while (LocationOfColorMovement <= 0.0) {
                        LocationOfColorMovement += RepeatLength;
                        this.numberOfTransitions += 1.0;
                    }
                    while (LocationOfColorMovement >= (RepeatLength + ColorsLength) / 2.0) {
                        LocationOfColorMovement -= RepeatLength;
                        this.numberOfTransitions -= 1.0;
                    }
                    FormulaValue = FormulaValue - LocationOfColorMovement + this.numberOfTransitions * RepeatLength + (RepeatLength + ColorsLength) / 2.0;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                        FormulaValue -= RepeatLength;
                    }
                    FormulaValue -= ColorsLength / 2.0;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= RepeatLength) {
                        FormulaValue -= RepeatLength;
                    }
                    if (FormulaValue >= RepeatLength / 2.0) {
                        return (FormulaValue += 3.0 * RepeatLength / 2.0) - RepeatLength;
                    }
                    return -FormulaValue;
                }
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfColorMovement = -LocationOfColorMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (LocationOfColorMovement <= 0.0) {
                    LocationOfColorMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfColorMovement >= (RepeatLength + ColorsLength) / 2.0) {
                    LocationOfColorMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = FormulaValue - LocationOfColorMovement + this.numberOfTransitions * RepeatLength + (RepeatLength + ColorsLength) / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
            }
        }
        return FormulaValue;
    }

    public double SliderFormulateSlidingTransitionsSameColors(double ColorsLength, double FormulaValue, double LocationOfStillMovement, double RepeatLength) {
        boolean negativeColorsLength = false;
        boolean negativeRepeatLength = false;
        if (ColorsLength < 0.0) {
            negativeColorsLength = true;
            ColorsLength = Math.abs(ColorsLength);
        }
        if (RepeatLength < 0.0) {
            negativeRepeatLength = true;
            RepeatLength = Math.abs(RepeatLength);
        }
        if (RepeatLength == ColorsLength) {
            if (negativeRepeatLength && negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
                while (RepeatLength - FormulaValue <= 0.0) {
                    FormulaValue -= RepeatLength;
                }
                while (RepeatLength - FormulaValue >= RepeatLength) {
                    FormulaValue += RepeatLength;
                }
                if (FormulaValue - RepeatLength <= -RepeatLength / 2.0) {
                    FormulaValue += 2.0 * RepeatLength;
                }
                return FormulaValue - RepeatLength;
            }
            if (negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
                while (RepeatLength - FormulaValue <= 0.0) {
                    FormulaValue -= RepeatLength;
                }
                while (RepeatLength - FormulaValue >= RepeatLength) {
                    FormulaValue += RepeatLength;
                }
                return RepeatLength - FormulaValue;
            }
            if (negativeRepeatLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
                if (FormulaValue >= RepeatLength / 2.0) {
                    return (FormulaValue += 3.0 * RepeatLength / 2.0) - RepeatLength;
                }
                return -FormulaValue;
            }
            this.numberOfTransitions = 0.0;
            FormulaValue = FormulaValue * RepeatLength / ColorsLength;
            while (FormulaValue <= 0.0) {
                FormulaValue += RepeatLength;
            }
            while (FormulaValue >= RepeatLength) {
                FormulaValue -= RepeatLength;
            }
            LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
            while (LocationOfStillMovement <= 0.0) {
                LocationOfStillMovement += RepeatLength;
                this.numberOfTransitions += 1.0;
            }
            while (LocationOfStillMovement >= RepeatLength) {
                LocationOfStillMovement -= RepeatLength;
                this.numberOfTransitions -= 1.0;
            }
            FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
            while (FormulaValue <= 0.0) {
                FormulaValue += ColorsLength;
            }
            while (FormulaValue >= ColorsLength) {
                FormulaValue -= ColorsLength;
            }
        } else if (RepeatLength < ColorsLength) {
            if (negativeRepeatLength && negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
                FormulaValue -= ColorsLength / 2.0;
                while (ColorsLength - FormulaValue <= 0.0) {
                    FormulaValue -= ColorsLength;
                }
                while (ColorsLength - FormulaValue >= ColorsLength) {
                    FormulaValue += ColorsLength;
                }
                if (FormulaValue - ColorsLength <= -ColorsLength / 2.0) {
                    FormulaValue += 2.0 * ColorsLength;
                }
                return FormulaValue - ColorsLength;
            }
            if (negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
            } else {
                if (negativeRepeatLength) {
                    this.numberOfTransitions = 0.0;
                    FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= RepeatLength) {
                        FormulaValue -= RepeatLength;
                    }
                    LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                    while (LocationOfStillMovement <= 0.0) {
                        LocationOfStillMovement += RepeatLength;
                        this.numberOfTransitions += 1.0;
                    }
                    while (LocationOfStillMovement >= RepeatLength) {
                        LocationOfStillMovement -= RepeatLength;
                        this.numberOfTransitions -= 1.0;
                    }
                    FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                    while (FormulaValue <= 0.0) {
                        FormulaValue += ColorsLength;
                    }
                    while (FormulaValue >= ColorsLength) {
                        FormulaValue -= ColorsLength;
                    }
                    while (FormulaValue <= 0.0) {
                        FormulaValue += ColorsLength;
                    }
                    while (FormulaValue >= ColorsLength) {
                        FormulaValue -= ColorsLength;
                    }
                    if (FormulaValue >= ColorsLength / 2.0) {
                        return FormulaValue + ColorsLength / 2.0;
                    }
                    return -FormulaValue - ColorsLength / 2.0;
                }
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
            }
        } else {
            if (negativeRepeatLength && negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= (RepeatLength + ColorsLength) / 2.0) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength + (RepeatLength + ColorsLength) / 2.0 : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                FormulaValue = RepeatLength - FormulaValue;
                while (RepeatLength - FormulaValue <= 0.0) {
                    FormulaValue -= RepeatLength;
                }
                while (RepeatLength - FormulaValue >= RepeatLength) {
                    FormulaValue += RepeatLength;
                }
                if (FormulaValue - RepeatLength <= -RepeatLength / 2.0) {
                    FormulaValue += 2.0 * RepeatLength;
                }
                return RepeatLength - FormulaValue;
            }
            if (negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= (RepeatLength + ColorsLength) / 2.0) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength + (RepeatLength + ColorsLength) / 2.0 : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
            } else {
                if (negativeRepeatLength) {
                    this.numberOfTransitions = 0.0;
                    FormulaValue = FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                        FormulaValue -= RepeatLength;
                    }
                    LocationOfStillMovement = -LocationOfStillMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                    while (LocationOfStillMovement <= 0.0) {
                        LocationOfStillMovement += RepeatLength;
                        this.numberOfTransitions += 1.0;
                    }
                    while (LocationOfStillMovement >= (RepeatLength + ColorsLength) / 2.0) {
                        LocationOfStillMovement -= RepeatLength;
                        this.numberOfTransitions -= 1.0;
                    }
                    FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength + (RepeatLength + ColorsLength) / 2.0 : (FormulaValue += this.numberOfTransitions * RepeatLength);
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                        FormulaValue -= RepeatLength;
                    }
                    FormulaValue -= ColorsLength / 2.0;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= RepeatLength) {
                        FormulaValue -= RepeatLength;
                    }
                    if (FormulaValue >= RepeatLength / 2.0) {
                        return (FormulaValue += 3.0 * RepeatLength / 2.0) - RepeatLength;
                    }
                    return -FormulaValue;
                }
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= (RepeatLength + ColorsLength) / 2.0) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength + (RepeatLength + ColorsLength) / 2.0 : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
            }
        }
        return FormulaValue;
    }

    public double SliderFormulateDoubleSliding(double ColorsLength, double FormulaValue, double LocationOfStillMovement, double LocationOfColorMovement, double RepeatLength) {
        boolean negativeColorsLength = false;
        boolean negativeRepeatLength = false;
        if (ColorsLength < 0.0) {
            negativeColorsLength = true;
            ColorsLength = Math.abs(ColorsLength);
        }
        if (RepeatLength < 0.0) {
            negativeRepeatLength = true;
            RepeatLength = Math.abs(RepeatLength);
        }
        FormulaValue += LocationOfColorMovement;
        if (RepeatLength == ColorsLength) {
            if (negativeRepeatLength && negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
                while (RepeatLength - FormulaValue <= 0.0) {
                    FormulaValue -= RepeatLength;
                }
                while (RepeatLength - FormulaValue >= RepeatLength) {
                    FormulaValue += RepeatLength;
                }
                if (FormulaValue - RepeatLength <= -RepeatLength / 2.0) {
                    FormulaValue += 2.0 * RepeatLength;
                }
                return FormulaValue - RepeatLength;
            }
            if (negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
                while (RepeatLength - FormulaValue <= 0.0) {
                    FormulaValue -= RepeatLength;
                }
                while (RepeatLength - FormulaValue >= RepeatLength) {
                    FormulaValue += RepeatLength;
                }
                return RepeatLength - FormulaValue;
            }
            if (negativeRepeatLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
                if (FormulaValue >= RepeatLength / 2.0) {
                    return (FormulaValue += 3.0 * RepeatLength / 2.0) - RepeatLength;
                }
                return -FormulaValue;
            }
            this.numberOfTransitions = 0.0;
            FormulaValue = FormulaValue * RepeatLength / ColorsLength;
            while (FormulaValue <= 0.0) {
                FormulaValue += RepeatLength;
            }
            while (FormulaValue >= RepeatLength) {
                FormulaValue -= RepeatLength;
            }
            LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
            while (LocationOfStillMovement <= 0.0) {
                LocationOfStillMovement += RepeatLength;
                this.numberOfTransitions += 1.0;
            }
            while (LocationOfStillMovement >= RepeatLength) {
                LocationOfStillMovement -= RepeatLength;
                this.numberOfTransitions -= 1.0;
            }
            FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
            while (FormulaValue <= 0.0) {
                FormulaValue += ColorsLength;
            }
            while (FormulaValue >= ColorsLength) {
                FormulaValue -= ColorsLength;
            }
            while (LocationOfStillMovement <= 0.0) {
                LocationOfStillMovement += RepeatLength;
            }
            while (LocationOfStillMovement >= RepeatLength) {
                LocationOfStillMovement -= RepeatLength;
            }
            if (FormulaValue >= LocationOfStillMovement) {
                FormulaValue -= LocationOfStillMovement;
            }
            while (FormulaValue <= 0.0) {
                FormulaValue += RepeatLength;
            }
            while (FormulaValue >= RepeatLength) {
                FormulaValue -= RepeatLength;
            }
        } else if (RepeatLength < ColorsLength) {
            if (negativeRepeatLength && negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
                FormulaValue = ColorsLength - FormulaValue;
                while (ColorsLength - FormulaValue <= 0.0) {
                    FormulaValue -= ColorsLength;
                }
                while (ColorsLength - FormulaValue >= ColorsLength) {
                    FormulaValue += ColorsLength;
                }
                if (FormulaValue - ColorsLength <= -ColorsLength / 2.0) {
                    FormulaValue += 2.0 * ColorsLength;
                }
                return FormulaValue - ColorsLength;
            }
            if (negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
            } else {
                if (negativeRepeatLength) {
                    this.numberOfTransitions = 0.0;
                    FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= RepeatLength) {
                        FormulaValue -= RepeatLength;
                    }
                    LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                    while (LocationOfStillMovement <= 0.0) {
                        LocationOfStillMovement += RepeatLength;
                        this.numberOfTransitions += 1.0;
                    }
                    while (LocationOfStillMovement >= RepeatLength) {
                        LocationOfStillMovement -= RepeatLength;
                        this.numberOfTransitions -= 1.0;
                    }
                    FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                    while (FormulaValue <= 0.0) {
                        FormulaValue += ColorsLength;
                    }
                    while (FormulaValue >= ColorsLength) {
                        FormulaValue -= ColorsLength;
                    }
                    if ((FormulaValue -= ColorsLength / 2.0) >= ColorsLength / 2.0) {
                        return FormulaValue + ColorsLength / 2.0;
                    }
                    return -FormulaValue - ColorsLength / 2.0;
                }
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue * RepeatLength / ColorsLength;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= RepeatLength) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement * RepeatLength / ColorsLength;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= RepeatLength) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += ColorsLength;
                }
                while (FormulaValue >= ColorsLength) {
                    FormulaValue -= ColorsLength;
                }
            }
        } else {
            if (negativeRepeatLength && negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= (RepeatLength + ColorsLength) / 2.0) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength + (RepeatLength + ColorsLength) / 2.0 : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                FormulaValue = RepeatLength - FormulaValue;
                while (RepeatLength - FormulaValue <= 0.0) {
                    FormulaValue -= RepeatLength;
                }
                while (RepeatLength - FormulaValue >= RepeatLength) {
                    FormulaValue += RepeatLength;
                }
                if (FormulaValue - RepeatLength <= -RepeatLength / 2.0) {
                    FormulaValue += 2.0 * RepeatLength;
                }
                return FormulaValue - RepeatLength;
            }
            if (negativeColorsLength) {
                this.numberOfTransitions = 0.0;
                FormulaValue = -FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= (RepeatLength + ColorsLength) / 2.0) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength + (RepeatLength + ColorsLength) / 2.0 : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
            } else {
                if (negativeRepeatLength) {
                    this.numberOfTransitions = 0.0;
                    FormulaValue = FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                        FormulaValue -= RepeatLength;
                    }
                    LocationOfStillMovement = -LocationOfStillMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                    while (LocationOfStillMovement <= 0.0) {
                        LocationOfStillMovement += RepeatLength;
                        this.numberOfTransitions += 1.0;
                    }
                    while (LocationOfStillMovement >= (RepeatLength + ColorsLength) / 2.0) {
                        LocationOfStillMovement -= RepeatLength;
                        this.numberOfTransitions -= 1.0;
                    }
                    FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength + (RepeatLength + ColorsLength) / 2.0 : (FormulaValue += this.numberOfTransitions * RepeatLength);
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                        FormulaValue -= RepeatLength;
                    }
                    FormulaValue -= ColorsLength / 2.0;
                    while (FormulaValue <= 0.0) {
                        FormulaValue += RepeatLength;
                    }
                    while (FormulaValue >= RepeatLength) {
                        FormulaValue -= RepeatLength;
                    }
                    if (FormulaValue >= RepeatLength / 2.0) {
                        return (FormulaValue += 3.0 * RepeatLength / 2.0) - RepeatLength;
                    }
                    return -FormulaValue;
                }
                this.numberOfTransitions = 0.0;
                FormulaValue = FormulaValue + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
                LocationOfStillMovement = -LocationOfStillMovement + (RepeatLength + ColorsLength) / 2.0 + RepeatLength / ColorsLength * RepeatLength / 2.0;
                while (LocationOfStillMovement <= 0.0) {
                    LocationOfStillMovement += RepeatLength;
                    this.numberOfTransitions += 1.0;
                }
                while (LocationOfStillMovement >= (RepeatLength + ColorsLength) / 2.0) {
                    LocationOfStillMovement -= RepeatLength;
                    this.numberOfTransitions -= 1.0;
                }
                FormulaValue = LocationOfStillMovement <= FormulaValue ? FormulaValue - LocationOfStillMovement + (this.numberOfTransitions + 1.0) * RepeatLength + (RepeatLength + ColorsLength) / 2.0 : (FormulaValue += this.numberOfTransitions * RepeatLength);
                while (FormulaValue <= 0.0) {
                    FormulaValue += RepeatLength;
                }
                while (FormulaValue >= (RepeatLength + ColorsLength) / 2.0) {
                    FormulaValue -= RepeatLength;
                }
            }
        }
        return FormulaValue;
    }

    public double ColorValueFitter(double ColorToBeChecked) {
        this.colorBeingChecked = ColorToBeChecked;
        while (this.colorBeingChecked < -4080.0) {
            this.colorBeingChecked += 4080.0;
        }
        while (this.colorBeingChecked < 0.0) {
            this.colorBeingChecked += 255.0;
        }
        while (this.colorBeingChecked > 4080.0) {
            this.colorBeingChecked -= 4080.0;
        }
        while (this.colorBeingChecked > 255.0) {
            this.colorBeingChecked -= 255.0;
        }
        return Math.round(this.colorBeingChecked);
    }

    public double OpacityValueFitter(double OpacityToBeChecked) {
        this.opacityBeingChecked = OpacityToBeChecked;
        while (this.opacityBeingChecked < -16.0) {
            this.opacityBeingChecked += 16.0;
        }
        while (this.opacityBeingChecked < 0.0) {
            this.opacityBeingChecked += 1.0;
        }
        while (this.opacityBeingChecked > 16.0) {
            this.opacityBeingChecked -= 16.0;
        }
        while (this.opacityBeingChecked > 1.0) {
            this.opacityBeingChecked -= 1.0;
        }
        return this.opacityBeingChecked;
    }

    public void set(double[] ARGB) {
        this.argb = ARGB;
        this.rgb[0] = this.argb[0];
        this.rgb[1] = this.argb[1];
        this.rgb[2] = this.argb[2];
        this.fxColor = Color.rgb((int)this.ColorValueFitter(this.argb[0]), (int)this.ColorValueFitter(this.argb[1]), (int)this.ColorValueFitter(this.argb[2]), this.OpacityValueFitter(this.argb[3]));
        this.color = new RainbowSoftColor(this.argb);
    }

    public void set(Color FXColor) {
        this.fxColor = FXColor;
        this.argb = new double[]{FXColor.getRed() * 255.0, FXColor.getGreen() * 255.0, FXColor.getBlue() * 255.0, FXColor.getOpacity()};
        this.rgb = new double[]{FXColor.getRed() * 255.0, FXColor.getGreen() * 255.0, FXColor.getBlue() * 255.0};
        this.color = new RainbowSoftColor(this.argb);
    }

    public Color get() {
        return this.fxColor;
    }
}

