/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvArr;
import org.bytedeco.opencv.opencv_core.CvMat;
import org.bytedeco.opencv.opencv_core.CvScalar;
import org.bytedeco.opencv.opencv_core.IplImage;
import org.bytedeco.opencv.opencv_core.IplROI;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractCvMat
extends CvArr {
    protected BytePointer pointer;
    private int fullSize = 0;
    private ByteBuffer byteBuffer = null;
    private ShortBuffer shortBuffer = null;
    private IntBuffer intBuffer = null;
    private FloatBuffer floatBuffer = null;
    private DoubleBuffer doubleBuffer = null;

    public AbstractCvMat(Pointer p) {
        super(p);
    }

    public static CvMat create(int rows, int cols, int type) {
        CvMat m = opencv_core.cvCreateMat(rows, cols, type);
        if (m != null) {
            m.fullSize = m.size();
            m.deallocator(new ReleaseDeallocator(m));
        }
        return m;
    }

    public static CvMat create(int rows, int cols, int depth, int channels) {
        return AbstractCvMat.create(rows, cols, opencv_core.CV_MAKETYPE(depth, channels));
    }

    public static CvMat create(int rows, int cols) {
        return AbstractCvMat.create(rows, cols, 6, 1);
    }

    public static CvMat createHeader(int rows, int cols, int type) {
        CvMat m = opencv_core.cvCreateMatHeader(rows, cols, type);
        if (m != null) {
            m.fullSize = m.size();
            m.deallocator(new ReleaseDeallocator(m));
        }
        return m;
    }

    public static CvMat createHeader(int rows, int cols, int depth, int channels) {
        return AbstractCvMat.createHeader(rows, cols, opencv_core.CV_MAKETYPE(depth, channels));
    }

    public static CvMat createHeader(int rows, int cols) {
        return AbstractCvMat.createHeader(rows, cols, 6, 1);
    }

    public static CvMat create(int rows, int cols, int depth, int channels, Pointer data) {
        CvMat m = AbstractCvMat.createHeader(rows, cols, depth, channels);
        m.pointer = new BytePointer(data);
        m.data_ptr(m.pointer);
        return m;
    }

    public static ThreadLocal<CvMat> createThreadLocal(final int rows, final int cols, final int type) {
        return new ThreadLocal<CvMat>(){

            @Override
            protected CvMat initialValue() {
                return AbstractCvMat.create(rows, cols, type);
            }
        };
    }

    public static ThreadLocal<CvMat> createThreadLocal(int rows, int cols, int depth, int channels) {
        return AbstractCvMat.createThreadLocal(rows, cols, opencv_core.CV_MAKETYPE(depth, channels));
    }

    public static ThreadLocal<CvMat> createThreadLocal(int rows, int cols) {
        return AbstractCvMat.createThreadLocal(rows, cols, 6, 1);
    }

    public static ThreadLocal<CvMat> createHeaderThreadLocal(final int rows, final int cols, final int type) {
        return new ThreadLocal<CvMat>(){

            @Override
            protected CvMat initialValue() {
                return AbstractCvMat.createHeader(rows, cols, type);
            }
        };
    }

    public static ThreadLocal<CvMat> createHeaderThreadLocal(int rows, int cols, int depth, int channels) {
        return AbstractCvMat.createHeaderThreadLocal(rows, cols, opencv_core.CV_MAKETYPE(depth, channels));
    }

    public static ThreadLocal<CvMat> createHeaderThreadLocal(int rows, int cols) {
        return AbstractCvMat.createHeaderThreadLocal(rows, cols, 6, 1);
    }

    public CvMat clone() {
        CvMat m = opencv_core.cvCloneMat((CvMat)this);
        if (m != null) {
            m.deallocator(new ReleaseDeallocator(m));
        }
        return m;
    }

    public void release() {
        this.deallocate();
    }

    public abstract int type();

    public abstract CvMat type(int var1);

    public abstract int step();

    public abstract BytePointer data_ptr();

    public abstract FloatPointer data_fl();

    public abstract DoublePointer data_db();

    public abstract IntPointer data_i();

    public abstract ShortPointer data_s();

    public abstract int rows();

    public abstract int cols();

    public int matType() {
        return opencv_core.CV_MAT_TYPE(this.type());
    }

    public void type(int depth, int cn) {
        this.type(opencv_core.CV_MAKETYPE(depth, cn) | 0x42420000);
    }

    public int depth() {
        return opencv_core.CV_MAT_DEPTH(this.type());
    }

    public int channels() {
        return opencv_core.CV_MAT_CN(this.type());
    }

    public int nChannels() {
        return opencv_core.CV_MAT_CN(this.type());
    }

    public boolean isContinuous() {
        return opencv_core.CV_IS_MAT_CONT(this.type()) != 0;
    }

    public int elemSize() {
        switch (this.depth()) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return 4;
            }
            case 6: {
                return 8;
            }
        }
        assert (false);
        return 0;
    }

    public int length() {
        return this.rows() * this.cols();
    }

    public int total() {
        return this.rows() * this.cols();
    }

    public boolean empty() {
        return this.length() == 0;
    }

    public int size() {
        int rows = this.rows();
        return this.cols() * this.elemSize() * this.channels() + (rows > 1 ? this.step() * (rows - 1) : 0);
    }

    @Override
    public int arrayChannels() {
        return this.channels();
    }

    @Override
    public int arrayDepth() {
        switch (this.depth()) {
            case 0: {
                return 8;
            }
            case 1: {
                return -2147483640;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return -2147483632;
            }
            case 4: {
                return -2147483616;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
        }
        assert (false);
        return -1;
    }

    @Override
    public int arrayOrigin() {
        return 0;
    }

    @Override
    public void arrayOrigin(int origin) {
    }

    @Override
    public int arrayWidth() {
        return this.cols();
    }

    @Override
    public int arrayHeight() {
        return this.rows();
    }

    @Override
    public IplROI arrayROI() {
        return null;
    }

    @Override
    public long arraySize() {
        return this.size();
    }

    @Override
    public BytePointer arrayData() {
        return this.data_ptr();
    }

    @Override
    public long arrayStep() {
        return this.step();
    }

    @Deprecated
    public void reset() {
        this.fullSize = 0;
        this.byteBuffer = null;
        this.shortBuffer = null;
        this.intBuffer = null;
        this.floatBuffer = null;
        this.doubleBuffer = null;
    }

    private int fullSize() {
        return this.fullSize > 0 ? this.fullSize : (this.fullSize = this.size());
    }

    @Override
    @Deprecated
    public ByteBuffer getByteBuffer() {
        if (this.byteBuffer == null) {
            this.byteBuffer = this.data_ptr().capacity(this.fullSize()).asBuffer();
        }
        this.byteBuffer.position(0);
        return this.byteBuffer;
    }

    @Override
    @Deprecated
    public ShortBuffer getShortBuffer() {
        if (this.shortBuffer == null) {
            this.shortBuffer = this.data_s().capacity(this.fullSize() / 2).asBuffer();
        }
        this.shortBuffer.position(0);
        return this.shortBuffer;
    }

    @Override
    @Deprecated
    public IntBuffer getIntBuffer() {
        if (this.intBuffer == null) {
            this.intBuffer = this.data_i().capacity(this.fullSize() / 4).asBuffer();
        }
        this.intBuffer.position(0);
        return this.intBuffer;
    }

    @Override
    @Deprecated
    public FloatBuffer getFloatBuffer() {
        if (this.floatBuffer == null) {
            this.floatBuffer = this.data_fl().capacity(this.fullSize() / 4).asBuffer();
        }
        this.floatBuffer.position(0);
        return this.floatBuffer;
    }

    @Override
    @Deprecated
    public DoubleBuffer getDoubleBuffer() {
        if (this.doubleBuffer == null) {
            this.doubleBuffer = this.data_db().capacity(this.fullSize() / 8).asBuffer();
        }
        this.doubleBuffer.position(0);
        return this.doubleBuffer;
    }

    @Deprecated
    public double get(int i) {
        switch (this.depth()) {
            case 0: {
                return this.getByteBuffer().get(i) & 0xFF;
            }
            case 1: {
                return this.getByteBuffer().get(i);
            }
            case 2: {
                return this.getShortBuffer().get(i) & 0xFFFF;
            }
            case 3: {
                return this.getShortBuffer().get(i);
            }
            case 4: {
                return this.getIntBuffer().get(i);
            }
            case 5: {
                return this.getFloatBuffer().get(i);
            }
            case 6: {
                return this.getDoubleBuffer().get(i);
            }
        }
        assert (false);
        return Double.NaN;
    }

    @Deprecated
    public double get(int i, int j) {
        return this.get(i * this.step() / this.elemSize() + j * this.channels());
    }

    @Deprecated
    public double get(int i, int j, int k) {
        return this.get(i * this.step() / this.elemSize() + j * this.channels() + k);
    }

    @Deprecated
    public synchronized CvMat get(int index, double[] vv, int offset, int length) {
        int d = this.depth();
        switch (d) {
            case 0: 
            case 1: {
                ByteBuffer bb = this.getByteBuffer();
                bb.position(index);
                for (int i = 0; i < length; ++i) {
                    vv[i + offset] = d == 0 ? (double)(bb.get(i) & 0xFF) : (double)bb.get(i);
                }
                break;
            }
            case 2: 
            case 3: {
                ShortBuffer sb = this.getShortBuffer();
                sb.position(index);
                for (int i = 0; i < length; ++i) {
                    vv[i + offset] = d == 2 ? (double)(sb.get() & 0xFFFF) : (double)sb.get();
                }
                break;
            }
            case 4: {
                IntBuffer ib = this.getIntBuffer();
                ib.position(index);
                for (int i = 0; i < length; ++i) {
                    vv[i + offset] = ib.get();
                }
                break;
            }
            case 5: {
                FloatBuffer fb = this.getFloatBuffer();
                fb.position(index);
                for (int i = 0; i < length; ++i) {
                    vv[i + offset] = fb.get();
                }
                break;
            }
            case 6: {
                this.getDoubleBuffer().position(index);
                this.getDoubleBuffer().get(vv, offset, length);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return (CvMat)this;
    }

    @Deprecated
    public CvMat get(int index, double[] vv) {
        return this.get(index, vv, 0, vv.length);
    }

    @Deprecated
    public CvMat get(double[] vv) {
        return this.get(0, vv);
    }

    @Deprecated
    public double[] get() {
        double[] vv = new double[this.fullSize() / this.elemSize()];
        this.get(vv);
        return vv;
    }

    @Deprecated
    public CvMat put(int i, double v) {
        switch (this.depth()) {
            case 0: 
            case 1: {
                this.getByteBuffer().put(i, (byte)v);
                break;
            }
            case 2: 
            case 3: {
                this.getShortBuffer().put(i, (short)v);
                break;
            }
            case 4: {
                this.getIntBuffer().put(i, (int)v);
                break;
            }
            case 5: {
                this.getFloatBuffer().put(i, (float)v);
                break;
            }
            case 6: {
                this.getDoubleBuffer().put(i, v);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return (CvMat)this;
    }

    @Deprecated
    public CvMat put(int i, int j, double v) {
        return this.put(i * this.step() / this.elemSize() + j * this.channels(), v);
    }

    @Deprecated
    public CvMat put(int i, int j, int k, double v) {
        return this.put(i * this.step() / this.elemSize() + j * this.channels() + k, v);
    }

    @Deprecated
    public synchronized CvMat put(int index, double[] vv, int offset, int length) {
        switch (this.depth()) {
            case 0: 
            case 1: {
                ByteBuffer bb = this.getByteBuffer();
                bb.position(index);
                for (int i = 0; i < length; ++i) {
                    bb.put((byte)vv[i + offset]);
                }
                break;
            }
            case 2: 
            case 3: {
                ShortBuffer sb = this.getShortBuffer();
                sb.position(index);
                for (int i = 0; i < length; ++i) {
                    sb.put((short)vv[i + offset]);
                }
                break;
            }
            case 4: {
                IntBuffer ib = this.getIntBuffer();
                ib.position(index);
                for (int i = 0; i < length; ++i) {
                    ib.put((int)vv[i + offset]);
                }
                break;
            }
            case 5: {
                FloatBuffer fb = this.getFloatBuffer();
                fb.position(index);
                for (int i = 0; i < length; ++i) {
                    fb.put((float)vv[i + offset]);
                }
                break;
            }
            case 6: {
                DoubleBuffer db = this.getDoubleBuffer();
                db.position(index);
                db.put(vv, offset, length);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return (CvMat)this;
    }

    @Deprecated
    public CvMat put(int index, double ... vv) {
        return this.put(index, vv, 0, vv.length);
    }

    @Deprecated
    public CvMat put(double ... vv) {
        return this.put(0, vv);
    }

    public CvMat put(CvMat mat) {
        return this.put(0, 0, 0, mat, 0, 0, 0);
    }

    public synchronized CvMat put(int dsti, int dstj, int dstk, CvMat mat, int srci, int srcj, int srck) {
        if (this.rows() == mat.rows() && this.cols() == mat.cols() && this.step() == mat.step() && this.type() == mat.type() && dsti == 0 && dstj == 0 && dstk == 0 && srci == 0 && srcj == 0 && srck == 0) {
            this.getByteBuffer().clear();
            mat.getByteBuffer().clear();
            this.getByteBuffer().put(mat.getByteBuffer());
        } else {
            int w = Math.min(this.rows() - dsti, mat.rows() - srci);
            int h = Math.min(this.cols() - dstj, mat.cols() - srcj);
            int d = Math.min(this.channels() - dstk, mat.channels() - srck);
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    for (int k = 0; k < d; ++k) {
                        this.put(i + dsti, j + dstj, k + dstk, mat.get(i + srci, j + srcj, k + srck));
                    }
                }
            }
        }
        return (CvMat)this;
    }

    public IplImage asIplImage() {
        IplImage image = new IplImage();
        opencv_core.cvGetImage(this, image);
        return image;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuilder s = new StringBuilder("[ ");
        int channels = this.channels();
        for (int i = 0; i < this.rows(); ++i) {
            int j;
            for (j = 0; j < this.cols(); ++j) {
                CvScalar v = opencv_core.cvGet2D(this, i, j);
                if (channels > 1) {
                    s.append("(");
                }
                for (int k = 0; k < channels; ++k) {
                    s.append((float)v.val(k));
                    if (k >= channels - 1) continue;
                    s.append(", ");
                }
                if (channels > 1) {
                    s.append(")");
                }
                if (j >= this.cols() - 1) continue;
                s.append(", ");
            }
            if (i >= this.rows() - 1) continue;
            s.append("\n  ");
            for (j = 0; j < indent; ++j) {
                s.append(' ');
            }
        }
        s.append(" ]");
        return s.toString();
    }

    protected static class ReleaseDeallocator
    extends CvMat
    implements Pointer.Deallocator {
        ReleaseDeallocator(CvMat m) {
            super(m);
        }

        @Override
        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            opencv_core.cvReleaseMat(this);
            this.setNull();
        }
    }
}

