package org.openqa.selenium.devtools.v139.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class DirectTCPSocketOptions {

    private final java.lang.Boolean noDelay;

    private final java.util.Optional<java.lang.Number> keepAliveDelay;

    private final java.util.Optional<java.lang.Number> sendBufferSize;

    private final java.util.Optional<java.lang.Number> receiveBufferSize;

    private final java.util.Optional<org.openqa.selenium.devtools.v139.network.model.DirectSocketDnsQueryType> dnsQueryType;

    public DirectTCPSocketOptions(java.lang.Boolean noDelay, java.util.Optional<java.lang.Number> keepAliveDelay, java.util.Optional<java.lang.Number> sendBufferSize, java.util.Optional<java.lang.Number> receiveBufferSize, java.util.Optional<org.openqa.selenium.devtools.v139.network.model.DirectSocketDnsQueryType> dnsQueryType) {
        this.noDelay = java.util.Objects.requireNonNull(noDelay, "noDelay is required");
        this.keepAliveDelay = keepAliveDelay;
        this.sendBufferSize = sendBufferSize;
        this.receiveBufferSize = receiveBufferSize;
        this.dnsQueryType = dnsQueryType;
    }

    /**
     * TCP_NODELAY option
     */
    public java.lang.Boolean getNoDelay() {
        return noDelay;
    }

    /**
     * Expected to be unsigned integer.
     */
    public java.util.Optional<java.lang.Number> getKeepAliveDelay() {
        return keepAliveDelay;
    }

    /**
     * Expected to be unsigned integer.
     */
    public java.util.Optional<java.lang.Number> getSendBufferSize() {
        return sendBufferSize;
    }

    /**
     * Expected to be unsigned integer.
     */
    public java.util.Optional<java.lang.Number> getReceiveBufferSize() {
        return receiveBufferSize;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v139.network.model.DirectSocketDnsQueryType> getDnsQueryType() {
        return dnsQueryType;
    }

    private static DirectTCPSocketOptions fromJson(JsonInput input) {
        java.lang.Boolean noDelay = false;
        java.util.Optional<java.lang.Number> keepAliveDelay = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> sendBufferSize = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> receiveBufferSize = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v139.network.model.DirectSocketDnsQueryType> dnsQueryType = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "noDelay":
                    noDelay = input.nextBoolean();
                    break;
                case "keepAliveDelay":
                    keepAliveDelay = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "sendBufferSize":
                    sendBufferSize = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "receiveBufferSize":
                    receiveBufferSize = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "dnsQueryType":
                    dnsQueryType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.network.model.DirectSocketDnsQueryType.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectTCPSocketOptions(noDelay, keepAliveDelay, sendBufferSize, receiveBufferSize, dnsQueryType);
    }
}
