/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.docker;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.grid.node.DefaultActiveSession;
import org.openqa.selenium.grid.node.docker.DockerAssetsPath;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.tracing.Tracer;

public class DockerSession
extends DefaultActiveSession {
    private static final Logger LOG = Logger.getLogger(DockerSession.class.getName());
    private final Container container;
    private final Container videoContainer;
    private final DockerAssetsPath assetsPath;

    DockerSession(Container container, Container videoContainer, Tracer tracer, HttpClient client, SessionId id, URL url, Capabilities stereotype, Capabilities capabilities, Dialect downstream, Dialect upstream, Instant startTime, DockerAssetsPath assetsPath) {
        super(tracer, client, id, url, downstream, upstream, stereotype, capabilities, startTime);
        this.container = Require.nonNull("Container", container);
        this.videoContainer = videoContainer;
        this.assetsPath = Require.nonNull("Assets path", assetsPath);
    }

    @Override
    public void stop() {
        if (this.videoContainer != null) {
            this.videoContainer.stop(Duration.ofSeconds(10L));
        }
        this.saveLogs();
        this.container.stop(Duration.ofMinutes(1L));
        super.stop();
    }

    private void saveLogs() {
        String sessionAssetsPath = this.assetsPath.getContainerPath(this.getId());
        String seleniumServerLog = String.format("%s/selenium-server.log", sessionAssetsPath);
        try {
            List<String> logs = this.container.getLogs().getLogLines();
            Files.write(Paths.get(seleniumServerLog, new String[0]), logs, new OpenOption[0]);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error saving logs", e);
        }
    }
}

