/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.impl;

import graphql.Assert;
import graphql.Internal;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLSchemaElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class StronglyConnectedComponentsTopologicallySorted {
    private int index;
    private final Map<GraphQLSchemaElement, Integer> nodeToIndex = new LinkedHashMap<GraphQLSchemaElement, Integer>();
    private final Map<GraphQLSchemaElement, Integer> nodeToLowLink = new LinkedHashMap<GraphQLSchemaElement, Integer>();
    private final Map<GraphQLSchemaElement, Boolean> nodeToOnStack = new LinkedHashMap<GraphQLSchemaElement, Boolean>();
    private final Deque<GraphQLSchemaElement> stack = new ArrayDeque<GraphQLSchemaElement>();
    private final List<List<GraphQLSchemaElement>> result = new ArrayList<List<GraphQLSchemaElement>>();
    private final Map<GraphQLSchemaElement, List<GraphQLSchemaElement>> reverseDependencies;
    private final Map<String, List<GraphQLSchemaElement>> typeRefReverseDependencies;

    private StronglyConnectedComponentsTopologicallySorted(Map<GraphQLSchemaElement, List<GraphQLSchemaElement>> reverseDependencies, Map<String, List<GraphQLSchemaElement>> typeRefReverseDependencies) {
        this.reverseDependencies = reverseDependencies;
        this.typeRefReverseDependencies = typeRefReverseDependencies;
    }

    public static List<List<GraphQLSchemaElement>> getStronglyConnectedComponentsTopologicallySorted(Map<GraphQLSchemaElement, List<GraphQLSchemaElement>> reverseDependencies, Map<String, List<GraphQLSchemaElement>> typeRefReverseDependencies) {
        StronglyConnectedComponentsTopologicallySorted sccTopSort = new StronglyConnectedComponentsTopologicallySorted(reverseDependencies, typeRefReverseDependencies);
        sccTopSort.calculate();
        return sccTopSort.result;
    }

    private void calculate() {
        this.index = 0;
        for (GraphQLSchemaElement v : this.reverseDependencies.keySet()) {
            if (this.nodeToIndex.get(v) != null) continue;
            this.stronglyConnect(v);
        }
    }

    private void stronglyConnect(GraphQLSchemaElement v) {
        Object name;
        this.nodeToIndex.put(v, this.index);
        this.nodeToLowLink.put(v, this.index);
        ++this.index;
        this.stack.push(v);
        this.nodeToOnStack.put(v, true);
        List<GraphQLSchemaElement> dependencies = this.reverseDependencies.get(v);
        if (dependencies == null) {
            dependencies = new ArrayList<GraphQLSchemaElement>();
        }
        if (v instanceof GraphQLNamedType && this.typeRefReverseDependencies.containsKey(name = ((GraphQLNamedType)v).getName())) {
            dependencies = new ArrayList<GraphQLSchemaElement>(dependencies);
            dependencies.addAll((Collection<GraphQLSchemaElement>)this.typeRefReverseDependencies.get(name));
        }
        for (GraphQLSchemaElement w : dependencies) {
            if (this.nodeToIndex.get(w) == null) {
                this.stronglyConnect(w);
                this.nodeToLowLink.put(v, Math.min(this.nodeToLowLink.get(v), this.nodeToLowLink.get(w)));
                continue;
            }
            if (!Boolean.TRUE.equals(this.nodeToOnStack.get(w))) continue;
            this.nodeToLowLink.put(v, Math.min(this.nodeToLowLink.get(v), this.nodeToIndex.get(w)));
        }
        if (this.nodeToLowLink.get(v).equals(this.nodeToIndex.get(v))) {
            GraphQLSchemaElement w;
            LinkedHashSet<GraphQLSchemaElement> newSCC = new LinkedHashSet<GraphQLSchemaElement>();
            do {
                w = this.stack.pop();
                this.nodeToOnStack.put(w, false);
                newSCC.add(w);
            } while (w != v);
            this.result.add(this.topologicallySort(newSCC));
        }
    }

    private List<GraphQLSchemaElement> topologicallySort(Set<GraphQLSchemaElement> allNodes) {
        Iterator iterator;
        ArrayList<GraphQLSchemaElement> result = new ArrayList<GraphQLSchemaElement>();
        LinkedHashSet<GraphQLSchemaElement> notPermMarked = new LinkedHashSet<GraphQLSchemaElement>(allNodes);
        LinkedHashSet<GraphQLSchemaElement> tempMarked = new LinkedHashSet<GraphQLSchemaElement>();
        LinkedHashSet<GraphQLSchemaElement> permMarked = new LinkedHashSet<GraphQLSchemaElement>();
        while ((iterator = notPermMarked.iterator()).hasNext()) {
            GraphQLSchemaElement n = (GraphQLSchemaElement)iterator.next();
            iterator.remove();
            this.visit(n, tempMarked, permMarked, notPermMarked, result, allNodes);
        }
        return result;
    }

    private void visit(GraphQLSchemaElement n, Set<GraphQLSchemaElement> tempMarked, Set<GraphQLSchemaElement> permMarked, Set<GraphQLSchemaElement> notPermMarked, List<GraphQLSchemaElement> result, Set<GraphQLSchemaElement> allNodes) {
        if (permMarked.contains(n)) {
            return;
        }
        if (tempMarked.contains(n)) {
            Assert.assertShouldNeverHappen("This schema is not forming an Directed Acyclic Graph : %s has already has a temporary mark", n);
            return;
        }
        tempMarked.add(n);
        if (this.reverseDependencies.containsKey(n)) {
            for (GraphQLSchemaElement m4 : this.reverseDependencies.get(n)) {
                if (!allNodes.contains(m4)) continue;
                this.visit(m4, tempMarked, permMarked, notPermMarked, result, allNodes);
            }
        }
        tempMarked.remove(n);
        permMarked.add(n);
        notPermMarked.remove(n);
        result.add(n);
    }
}

